/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.local.service.FunctionSubService;
import com.biz.crm.mdm.business.table.sdk.vo.PageEngineCompetenceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.service.CompetenceVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FunctionSubServiceImpl
implements FunctionSubService {
    @Autowired(required=false)
    private FunctionSubRepository functionSubRepository;
    @Autowired(required=false)
    private FunctionSubButtonRepository functionSubButtonRepository;
    @Autowired(required=false)
    private ColumnConfigRepository columnConfigRepository;
    @Autowired(required=false)
    private CompetenceVoService competenceVoService;

    @Override
    @Transactional
    public MdmFunctionSubEntity create(MdmFunctionSubEntity mdmFunctionSubEntity) {
        this.createValidation(mdmFunctionSubEntity);
        mdmFunctionSubEntity.setTenantCode(TenantUtils.getTenantCode());
        String code = StringUtils.join((Object[])new String[]{mdmFunctionSubEntity.getParentCode(), "@", mdmFunctionSubEntity.getFunctionCode()});
        mdmFunctionSubEntity.setCode(code);
        this.functionSubRepository.save((Object)mdmFunctionSubEntity);
        PageEngineCompetenceVo competenceVo = new PageEngineCompetenceVo();
        competenceVo.setType("PAGE_ENGINE");
        competenceVo.setCode(code);
        competenceVo.setComment(mdmFunctionSubEntity.getRemark());
        competenceVo.setViewItem(Integer.valueOf(BooleanEnum.FALSE.getNumStr()));
        String parentCode = mdmFunctionSubEntity.getParentCode();
        competenceVo.setParentCode(parentCode);
        this.competenceVoService.create((CompetenceVo)competenceVo);
        return mdmFunctionSubEntity;
    }

    @Override
    @Transactional
    public void update(MdmFunctionSubEntity mdmFunctionSubEntity) {
        MdmFunctionSubEntity entityDb = this.updateValidation(mdmFunctionSubEntity);
        this.functionSubRepository.updateById((Object)mdmFunctionSubEntity);
        String functionCode = mdmFunctionSubEntity.getFunctionCode();
        String parentCode = mdmFunctionSubEntity.getParentCode();
        String functionCodeDB = entityDb.getFunctionCode();
        if (functionCode.equals(functionCodeDB)) {
            return;
        }
        this.functionSubButtonRepository.updateFunctionCodeByParentCodeAndFunctionCode(parentCode, functionCodeDB, functionCode);
        this.columnConfigRepository.updateFunctionCodeByParentCodeAndFunctionCode(parentCode, functionCodeDB, functionCode);
        CompetenceVo competenceVo = this.competenceVoService.findByCompetenceCode(entityDb.getCode());
        String code = StringUtils.join((Object[])new String[]{mdmFunctionSubEntity.getParentCode(), "@", mdmFunctionSubEntity.getFunctionCode()});
        competenceVo.setCode(code);
        competenceVo.setType("PAGE_ENGINE");
        competenceVo.setComment(mdmFunctionSubEntity.getRemark());
        competenceVo.setViewItem(Integer.valueOf(BooleanEnum.FALSE.getNumStr()));
        competenceVo.setParentCode(parentCode);
        this.competenceVoService.update(competenceVo);
    }

    @Override
    @Transactional
    public void deleteByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MdmFunctionSubEntity> list = this.functionSubRepository.findByIdIn(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u5185\u4e0d\u5b58\u5728\uff0c\u9009\u4e2d\u7684\u6570\u636e", (Object[])new Object[0]);
        List<String> parentCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((CharSequence)x.getParentCode())).map(MdmFunctionSubEntity::getParentCode).collect(Collectors.toList());
        List<String> functionCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((CharSequence)x.getFunctionCode())).map(MdmFunctionSubEntity::getFunctionCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(parentCodeList) && !CollectionUtils.isEmpty(functionCodeList)) {
            this.functionSubButtonRepository.deleteByParentCodeInAndFunctionCodeIn(parentCodeList, functionCodeList);
            this.columnConfigRepository.deleteByParentCodeInAndFunctionCodeIn(parentCodeList, functionCodeList);
        }
        this.functionSubRepository.removeByIds(ids);
        List codeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((CharSequence)x.getCode())).map(MdmFunctionSubEntity::getCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        for (String code : codeList) {
            this.competenceVoService.deleteByCode(code);
        }
    }

    @Override
    @Transactional
    public void enableByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.functionSubRepository.updateEnableStatusByIdIn(ids, EnableStatusEnum.ENABLE.getCode());
    }

    @Override
    @Transactional
    public void disableByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.functionSubRepository.updateEnableStatusByIdIn(ids, EnableStatusEnum.DISABLE.getCode());
    }

    private MdmFunctionSubEntity updateValidation(MdmFunctionSubEntity mdmFunctionSubEntity) {
        Validate.notNull((Object)((Object)mdmFunctionSubEntity), (String)"\u4fee\u6539\u65f6\uff0c\u6a21\u578b\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        String functionCode = mdmFunctionSubEntity.getFunctionCode();
        Validate.notBlank((CharSequence)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String functionName = mdmFunctionSubEntity.getFunctionName();
        Validate.notBlank((CharSequence)functionName, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String id = mdmFunctionSubEntity.getId();
        Validate.notBlank((CharSequence)id, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String parentCode = mdmFunctionSubEntity.getParentCode();
        MdmFunctionSubEntity entity = this.functionSubRepository.findById(id);
        Validate.notNull((Object)((Object)entity), (String)"\u529f\u80fd\u5217\u8868\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<MdmFunctionSubEntity> functionSubList = this.functionSubRepository.findIdByParentCodeAndFunctionCode(parentCode, mdmFunctionSubEntity.getFunctionCode());
        long count = functionSubList.stream().filter(x -> !id.equals(x.getId())).count();
        Validate.isTrue((count < 1L ? 1 : 0) != 0, (String)"\u529f\u80fd\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        return entity;
    }

    private void createValidation(MdmFunctionSubEntity mdmFunctionSubEntity) {
        Validate.notBlank((CharSequence)mdmFunctionSubEntity.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubEntity.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count = this.functionSubRepository.countByParentCodeAndFunctionCode(mdmFunctionSubEntity.getParentCode(), mdmFunctionSubEntity.getFunctionCode());
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u529f\u80fd\u7f16\u7801\u5df2\u5b58\u5728");
    }
}

