package com.biz.crm.mdm.business.table.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigBatchCreateDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPaginationDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import cn.hutool.extra.spring.SpringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;

/**
 * @author hefan
 */
@Api(tags = "页面引擎：ColumnConfigVo: 字段配置")
@Slf4j
@RestController
@RequestMapping("/v1/table/columnConfig")
public class ColumnConfigVoController {

  @Autowired(required = false)
  private ColumnConfigVoService columnConfigVoService;

  /**
   * 分页 动态 条件 查询
   *
   * @param columnConfigPaginationDto
   * @return
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;" +
      "可传的参数：ColumnConfigPaginationDto")
  @GetMapping("/findByCondition")
  public Result<Page<ColumnConfigVo>> findByCondition(@PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "ColumnConfigPaginationDto", value = "分页Dto") ColumnConfigPaginationDto columnConfigPaginationDto) {
    try {
      Page<ColumnConfigVo> result = this.columnConfigVoService.findByCondition(pageable, columnConfigPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 根据parentCode、functionCode 查询，并按照 formorder 排序
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  @ApiOperation("根据parentCode、functionCode 查询，并按照 formorder 排序")
  @GetMapping("/findByParentCodeAndFunctionCodeOrderByFormorder")
  public Result<List<ColumnConfigVo>> findByParentCodeAndFunctionCodeOrderByFormorder(
      @ApiParam(name = "parentCode", value = "上级菜单") String parentCode,
      @ApiParam(name = "functionCode", value = "页面引擎主表") String functionCode) {
    try {
      List<ColumnConfigVo> result = this.columnConfigVoService.findByParentCodeAndFunctionCodeOrderByFormorder(parentCode, functionCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 根据parentCode、functionCode 查询，并按照 formorder 排序,且用中文过滤
   * 符号解释：
   *   7 - And      （&上面是7）
   *   9 - OrderBy  （O上面是9）
   *   4 - FilterBy （F上面是4）
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  @ApiOperation("根据parentCode、functionCode 查询，并按照 formorder 排序")
  @GetMapping("/findByParent7Func9Formorder4TitleCN")
  public Result<List<ColumnConfigVo>> findByParent7Func9Formorder4TitleCN(@ApiParam(name = "parentCode", value = "上级菜单") String parentCode,
                                                                          @ApiParam(name = "functionCode", value = "页面引擎主表") String functionCode) {
    try {
      List<ColumnConfigVo> result = this.columnConfigVoService.findByParent7Func9Formorder4TitleCN(parentCode, functionCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 根据 动态条件：parentCode，functionCode，field 查询 一条数据
   * fixme：这种动态条件，有没有必要做出dto。
   *
   * @param parentCode
   * @param functionCode
   * @param field
   * @return
   */
  @ApiOperation(value = "根据 动态条件：parentCode，functionCode，field 查询 一条数据")
  @GetMapping("/findByParentCodeAndFunctionCodeAndField")
  public Result<ColumnConfigVo> findByParentCodeAndFunctionCodeAndField(@ApiParam(name = "parentCode", value = "上级菜单") String parentCode,
                                                                        @ApiParam(name = "functionCode", value = "页面引擎主表") String functionCode,
                                                                        @ApiParam(name = "field", value = "属性") String field) {
    try {
      ColumnConfigVo columnConfigVo = this.columnConfigVoService.findByParentCodeAndFunctionCodeAndField(parentCode, functionCode, field);
      return Result.ok(columnConfigVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 新增 column_config，并删除 字段配置个性设置
   *
   * @param columnConfigBatchCreateDto
   * @return
   */
  @ApiOperation("批量新增 column_config，并删除 字段配置个性设置")
  @PostMapping("/createByColumnConfigBatchCreateDto")
  public Result<?> createByColumnConfigBatchCreateDto(@RequestBody @ApiParam(name = "columnConfigBatchCreateDto", value = "批量字段配置创建DTO") ColumnConfigBatchCreateDto columnConfigBatchCreateDto) {
    try {
      this.columnConfigVoService.createByColumnConfigBatchCreateDto(columnConfigBatchCreateDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 删除旧的后新增，并删除个性化字段配置。
   *
   * @param columnConfigDto
   * @return
   */
  @ApiOperation(value = "新增")
  @PostMapping("/createByColumnConfigDto")
  public Result<?> createByColumnConfigDto(@RequestBody @ApiParam(name = "columnConfigDto", value = "字段配置DTO") ColumnConfigDto columnConfigDto) {
    try {
      this.columnConfigVoService.createByColumnConfigDto(columnConfigDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 修改，并删除个性化字段配置
   *
   * @param columnConfigDto
   * @return
   */
  @ApiOperation(value = "修改，并删除个性化字段配置")
  @PatchMapping("/updateByColumnConfigDto")
  public Result<?> updateByColumnConfigDto(@RequestBody @ApiParam(name = "columnConfigDto", value = "字段配置DTO") ColumnConfigDto columnConfigDto) {
    try {
      this.columnConfigVoService.updateByColumnConfigDto(columnConfigDto);
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 根据ID集合批量删除，并删除了一条column_config信息下的个性化字段配置
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "deleteByIdIn: 根据ID集合批量删除，并删除了一条column_config信息下的个性化字段配置")
  @DeleteMapping("/deleteByIdIn")
  public Result<?> deleteByIdIn(@RequestParam @ApiParam(name = "ids", value = "id集合") List<String> ids) {
    try {
      this.columnConfigVoService.deleteByIdIn(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 根据 ID集合  启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "根据 ID集合 启用")
  @PatchMapping("/enableByIdIn")
  public Result<?> enableByIdIn(@RequestBody @ApiParam(name = "ids", value = "id集合") List<String> ids) {
    try {
      this.columnConfigVoService.enableByIdIn(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
