package com.biz.crm.mdm.business.table.local.service.internal;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigEntity;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigPersonalEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigPersonalRepository;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.local.service.ColumnConfigPersonalVoFeignService;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalDto;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;

/**
 * @author hefan
 */
@Service
public class ColumnConfigPersonalVoServiceImpl implements ColumnConfigPersonalVoFeignService {

  @Autowired(required = false)
  private ColumnConfigPersonalRepository columnConfigPersonalRepository;

  @Autowired(required = false)
  private ColumnConfigRepository columnConfigRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  private static Pattern pattern = Pattern.compile("[\\u4E00-\\u9FA5]+");

  @Override
  public List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    // hefan：获取当前登录人的岗位
    String positionCode = this.getCurPositionCode();
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    // hefan：根据 parentCode functionCode 查询 ColumnConfig
    List<MdmColumnConfigEntity> columnList = this.columnConfigRepository.findByParentCodeAndFunctionCode(parentCode, functionCode);
    if (CollectionUtils.isEmpty(columnList)) {
      return Lists.newLinkedList();
    }
    // hefan: 转换ColumnConfig为 vo
    List<ColumnConfigPersonalVo> collect = columnList.stream().map(x -> {
      ColumnConfigPersonalVo personalRespVo = new ColumnConfigPersonalVo();
      personalRespVo.setTitle(x.getTitle());
      personalRespVo.setField(x.getField());
      personalRespVo.setVisible(BooleanUtils.isTrue(x.getVisible()));
      personalRespVo.setFormOrder(StringUtils.isNotEmpty(x.getFormorder()) ? x.getFormorder() : "100");
      return personalRespVo;
    }).collect(Collectors.toList());
    // hefan：根据 positionCode parentCode functionCode 查询 个性化配置
    AbstractCrmUserIdentity loginUserDetails = loginUserService.getAbstractLoginUser();
    String account = loginUserDetails.getAccount();
    List<MdmColumnConfigPersonalEntity> list = this.columnConfigPersonalRepository.findByPosi7Parent7Func7Account(positionCode, parentCode, functionCode, account);
    if (!CollectionUtils.isEmpty(list)) {
      // hefan: 根据 个性化配置 赋值 columnConfig
      Map<String, MdmColumnConfigPersonalEntity> filedMap = list.stream()
          .collect(Collectors.toMap(MdmColumnConfigPersonalEntity::getField, v -> v));
      for (ColumnConfigPersonalVo item : collect) {
        if (!filedMap.containsKey(item.getField())) {
          item.setFormOrder("100");
        } else {
          MdmColumnConfigPersonalEntity mdmColumnConfigPersonalEntity = filedMap.get(item.getField());
          item.setVisible(mdmColumnConfigPersonalEntity.getVisible());
          item.setFormOrder(mdmColumnConfigPersonalEntity.getFormOrder());
          item.setFunctionCode(mdmColumnConfigPersonalEntity.getFunctionCode());
          item.setParentCode(mdmColumnConfigPersonalEntity.getParentCode());
          item.setPositionCode(mdmColumnConfigPersonalEntity.getPositionCode());
          item.setId(mdmColumnConfigPersonalEntity.getId());
        }
      }
    }
    Matcher matcher = pattern.matcher("");
    // hefan：把不是中文的隐藏了
    collect = collect.stream()
        .filter(x -> {
          String title = x.getTitle();
          if (StringUtils.isBlank(title)) {
            return false;
          }
          matcher.reset(title);
          return matcher.find();
        })
        .collect(Collectors.toList());
    collect.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormOrder()).map(Integer::valueOf).orElse(100)));
    return collect;
  }

  @Transactional
  @Override
  public void createByColumnConfigPersonalBatchDto(ColumnConfigPersonalBatchDto columnConfigPersonalBatchDto) {
    // 获取 当前登陆人的岗位code
    String positionCode = this.getCurPositionCode();
    String parentCode = columnConfigPersonalBatchDto.getParentCode();
    String functionCode = columnConfigPersonalBatchDto.getFunctionCode();
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    List<ColumnConfigPersonalDto> columnList = columnConfigPersonalBatchDto.getColumnList();
    Validate.notEmpty(columnList, "缺失字段配置");
    for (ColumnConfigPersonalDto item : columnList) {
      Validate.notBlank(item.getField(), "缺失属性");
      Validate.notNull(item.getVisible(), "缺失显示模式");
      Validate.notBlank(item.getFormOrder(), "缺失显示顺序");
      item.setFunctionCode(functionCode);
      item.setParentCode(parentCode);
      item.setPositionCode(positionCode);
    }
    //删除信息
    AbstractCrmUserIdentity loginUserDetails = loginUserService.getAbstractLoginUser();
    String account = loginUserDetails.getAccount();
    this.columnConfigPersonalRepository.deleteByParent7Func7Posi7Account(parentCode, functionCode, positionCode, account);
    // 批量 保存
    List<MdmColumnConfigPersonalEntity> mdmColumnConfigPersonalEntities = (List<MdmColumnConfigPersonalEntity>) this.nebulaToolkitService.copyCollectionByBlankList(columnList, ColumnConfigPersonalDto.class, MdmColumnConfigPersonalEntity.class, HashSet.class, LinkedList.class);
    this.columnConfigPersonalRepository.saveBatch(mdmColumnConfigPersonalEntities);
    // fixme: 原逻辑：清除缓存
  }

  @Transactional
  @Override
  public void deleteByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    String positionCode = this.getCurPositionCode();
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    this.columnConfigPersonalRepository.deleteByPositionCodeAndParentCodeAndFunctionCode(positionCode, parentCode, functionCode);
    // fixme: 原逻辑：清除缓存
  }

  @Override
  public List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCodeForExport(String parentCode, String functionCode, String account, String tenantCode) {
    TaskGlobalParamsVo paramsVo = new TaskGlobalParamsVo();
    paramsVo.setCreateAccount(account);
    paramsVo.setTenantCode(tenantCode);
    loginUserService.refreshAuthentication(paramsVo);
    return this.findByParentCodeAndFunctionCode(parentCode,functionCode);
  }

  private String getCurPositionCode() {
    AbstractCrmUserIdentity loginUserDetails = loginUserService.getAbstractLoginUser();
    return loginUserDetails.getPostCode();
  }


}
