/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigSelectVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigSelectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ColumnConfigSelectVoServiceImpl
implements ColumnConfigSelectVoService {
    @Autowired(required=false)
    private ColumnConfigRepository columnConfigRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ColumnConfigSelectVo> findByParentCodeAndFunctionCodeAndColumnExportOpt(String parentCode, String functionCode, String columnExport) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MdmColumnConfigEntity> list = this.columnConfigRepository.findByParentCodeAndFunctionCodeAndColumnExportOpt(parentCode, functionCode, columnExport);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        list.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder()).map(Integer::valueOf).orElse(100)));
        List result = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, MdmColumnConfigEntity.class, ColumnConfigSelectVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }
}

