/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubDto;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubPaginationDto;
import com.biz.crm.mdm.business.table.sdk.service.FunctionSubVoService;
import com.biz.crm.mdm.business.table.sdk.vo.FunctionSubVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class FunctionSubVoServiceImpl
implements FunctionSubVoService {
    @Autowired(required=false)
    private FunctionSubRepository functionSubRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<FunctionSubVo> findByCondition(Pageable pageable, FunctionSubPaginationDto functionSubPaginationDto) {
        if (Objects.isNull(functionSubPaginationDto)) {
            return null;
        }
        functionSubPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.functionSubRepository.findByCondition(pageable, functionSubPaginationDto);
    }

    public List<FunctionSubVo> findByFunctionSubDto(FunctionSubDto functionSubDto) {
        return this.functionSubRepository.findByFunctionSubDto(functionSubDto);
    }

    public FunctionSubVo findOneByParentCodeAndFunctionCode(String parentCode, String functionCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MdmFunctionSubEntity one = this.functionSubRepository.findOneByParentCodeAndFunctionCode(parentCode, functionCode);
        FunctionSubVo functionSubVo = (FunctionSubVo)this.nebulaToolkitService.copyObjectByBlankList((Object)one, FunctionSubVo.class, HashSet.class, LinkedList.class, new String[0]);
        return functionSubVo;
    }

    public FunctionSubVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MdmFunctionSubEntity one = this.functionSubRepository.findById(id);
        if (Objects.isNull((Object)one)) {
            return null;
        }
        FunctionSubVo functionSubVo = (FunctionSubVo)this.nebulaToolkitService.copyObjectByBlankList((Object)one, FunctionSubVo.class, HashSet.class, LinkedList.class, new String[0]);
        return functionSubVo;
    }

    public FunctionSubVo findByIdAndFunctionCode(String id, String functionCode) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MdmFunctionSubEntity one = this.functionSubRepository.findByIdAndFunctionCode(id, functionCode);
        if (Objects.isNull((Object)one)) {
            return null;
        }
        FunctionSubVo functionSubVo = (FunctionSubVo)this.nebulaToolkitService.copyObjectByBlankList((Object)one, FunctionSubVo.class, HashSet.class, LinkedList.class, new String[0]);
        return functionSubVo;
    }
}

