/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.sdk.dto.PermissionObjDto;
import com.biz.crm.mdm.business.table.sdk.service.PermissionObjVoService;
import com.biz.crm.mdm.business.table.sdk.vo.PermissionObjVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PermissionObjVoServiceImpl
implements PermissionObjVoService {
    private static final Logger log = LoggerFactory.getLogger(PermissionObjVoServiceImpl.class);
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private FunctionSubRepository functionSubRepository;

    public List<PermissionObjVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
        List permissionTree = this.dictToolkitService.tree("permission_obj");
        if (CollectionUtils.isEmpty((Collection)permissionTree)) {
            return new ArrayList<PermissionObjVo>();
        }
        MdmFunctionSubEntity mdmFunctionSubEntity = this.functionSubRepository.findPermissionObjByParentCodeAndFunctionCode(parentCode, functionCode);
        log.info("[\u6570\u636e\u6743\u9650][\u5df2\u914d\u7f6e\u7684\u6743\u9650\u5bf9\u8c61]:{}", (Object)mdmFunctionSubEntity);
        if (mdmFunctionSubEntity == null || StringUtils.isBlank((CharSequence)mdmFunctionSubEntity.getPermissionObj())) {
            return permissionTree.stream().map(x -> {
                PermissionObjVo permissionObjVo = new PermissionObjVo();
                permissionObjVo.setSelect(BooleanEnum.FALSE.getNumStr());
                permissionObjVo.setPermissionObjCode(x.getDictCode());
                permissionObjVo.setPermissionObjName(x.getDictValue());
                permissionObjVo.setRemarks(x.getDictValue());
                return permissionObjVo;
            }).collect(Collectors.toList());
        }
        List<String> permissionObjList = Arrays.asList(mdmFunctionSubEntity.getPermissionObj().split(","));
        return permissionTree.stream().map(x -> {
            PermissionObjVo permissionObjVo = new PermissionObjVo();
            if (permissionObjList.contains(x.getDictCode())) {
                permissionObjVo.setSelect(BooleanEnum.TRUE.getNumStr());
            } else {
                permissionObjVo.setSelect(BooleanEnum.FALSE.getNumStr());
            }
            permissionObjVo.setPermissionObjCode(x.getDictCode());
            permissionObjVo.setPermissionObjName(x.getDictValue());
            permissionObjVo.setRemarks(x.getDictValue());
            return permissionObjVo;
        }).collect(Collectors.toList());
    }

    @Transactional
    public void create(PermissionObjDto permissionObjDto) {
        String functionCode = permissionObjDto.getFunctionCode();
        Validate.notBlank((CharSequence)functionCode, (String)"\u529f\u80fd\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String parentCode = permissionObjDto.getParentCode();
        Validate.notBlank((CharSequence)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count = this.functionSubRepository.countByParentCodeAndFunctionCode(parentCode, functionCode);
        Validate.isTrue((count != null && count > 0 ? 1 : 0) != 0, (String)"\u529f\u80fd\u5217\u8868\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List permissionObjCodes = permissionObjDto.getPermissionObjCodes();
        if (CollectionUtils.isEmpty((Collection)permissionObjCodes)) {
            this.functionSubRepository.updatePermissionObjByParentCodeAndFunctionCode(parentCode, functionCode, null);
            return;
        }
        String collect = StringUtils.join((Iterable)permissionObjCodes, (String)",");
        this.functionSubRepository.updatePermissionObjByParentCodeAndFunctionCode(parentCode, functionCode, collect);
    }
}

