/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.notifier;

import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.service.FunctionSubButtonService;
import com.biz.crm.mdm.business.table.sdk.vo.PageEngineButtonVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.event.ButtonEventListener;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PageEngineButtonEventListener
implements ButtonEventListener {
    @Autowired(required=false)
    private FunctionSubButtonService functionSubButtonService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void onCreated(ButtonVo button) {
        if (!(button instanceof PageEngineButtonVo)) {
            return;
        }
        PageEngineButtonVo defaultButtonVo = (PageEngineButtonVo)button;
        String code = defaultButtonVo.getCode();
        MdmFunctionSubButtonEntity exsit = this.functionSubButtonService.findByCode(code);
        Validate.isTrue((exsit == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u53d1\u73b0\u9875\u9762\u5f15\u64ce\u6309\u94ae\u4e2d\u5df2\u7ecf\u5173\u8054\u4e86\u5bf9\u5e94\u7684\u6309\u94ae\u57fa\u672c\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MdmFunctionSubButtonEntity entity = (MdmFunctionSubButtonEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)defaultButtonVo, MdmFunctionSubButtonEntity.class, HashSet.class, LinkedList.class, new String[0]));
        entity.setButtonName(defaultButtonVo.getName());
        entity.setRemark(defaultButtonVo.getButtonDesc());
        entity.setIconCode(defaultButtonVo.getIcon());
        entity.setCode(defaultButtonVo.getCode());
        this.functionSubButtonService.create(entity);
    }

    public void onUpdate(ButtonVo button) {
        if (!(button instanceof PageEngineButtonVo)) {
            return;
        }
        PageEngineButtonVo defaultButtonVo = (PageEngineButtonVo)button;
        String code = defaultButtonVo.getCode();
        MdmFunctionSubButtonEntity exsitById = this.functionSubButtonService.findById(defaultButtonVo.getPageEngineButtonId());
        Validate.notNull((Object)((Object)exsitById), (String)"\u6839\u636ePageEngineButtonId\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", (Object[])new Object[0]);
        MdmFunctionSubButtonEntity exsitByCode = this.functionSubButtonService.findByCode(code);
        boolean isSame = Objects.nonNull((Object)exsitByCode) && exsitByCode.getId().equals(exsitById.getId());
        Validate.isTrue((Objects.isNull((Object)exsitByCode) || isSame ? 1 : 0) != 0, (String)"\u7f16\u7801\u5df2\u7ecf\u88ab\u5176\u5b83\u4fe1\u606f\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539", (Object[])new Object[0]);
        MdmFunctionSubButtonEntity entity = (MdmFunctionSubButtonEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)defaultButtonVo, MdmFunctionSubButtonEntity.class, HashSet.class, LinkedList.class, new String[0]));
        entity.setId(exsitById.getId());
        entity.setCreateAccount(exsitById.getCreateAccount());
        entity.setCreateTime(exsitById.getCreateTime());
        entity.setCreateName(exsitById.getCreateName());
        entity.setButtonName(defaultButtonVo.getName());
        entity.setRemark(defaultButtonVo.getButtonDesc());
        entity.setIconCode(defaultButtonVo.getIcon());
        entity.setCode(defaultButtonVo.getCode());
        this.functionSubButtonService.update(entity);
    }

    @Transactional
    public void onDeleted(ButtonVo button) {
        if (!(button instanceof PageEngineButtonVo)) {
            return;
        }
        String code = button.getCode();
        MdmFunctionSubButtonEntity exsit = this.functionSubButtonService.findByCode(code);
        Validate.notNull((Object)((Object)exsit), (String)"\u5220\u9664\u6309\u94ae\u65f6\uff0c\u53d1\u73b0\u9ed8\u8ba4\u6309\u94ae\u4e2d\u6ca1\u6709\u5173\u8054\u5bf9\u5e94\u7684\u6309\u94ae\u57fa\u672c\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList ids = Lists.newLinkedList();
        ids.add(exsit.getId());
        this.functionSubButtonService.deleteByIdIn(ids);
    }
}

