package com.biz.crm.mdm.business.table.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.sdk.service.ButtonConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * ButtonConfigVo: 按钮信息（含图标）
 * @author hefan
 */
@Api(tags = "页面引擎：ButtonConfigVo: 按钮信息（含图标）")
@Slf4j
@RestController
@RequestMapping("/v1/table/buttonConfig")
public class ButtonConfigVoController {


  @Autowired(required = false)
  private ButtonConfigVoService buttonConfigVoService;

  /**
   * hefan：mdm_function_sub_button 、mdm_button 、 mdm_icon
   * 根据 菜单，页面模板 查询 按钮信息（含图标）
   * 分页
   * @param parentCode
   * @param functionCode
   * @return
   */
  @ApiOperation("根据 菜单，页面模板 查询 按钮信息（含图标）分页")
  @GetMapping("/findByParentCodeAndFunctionCodePage")
  public Result<Page<ButtonConfigVo>> findByParentCodeAndFunctionCodePage(@PageableDefault(50) Pageable pageable, String parentCode, String functionCode) {
    try {
      Page<ButtonConfigVo> list = this.buttonConfigVoService.findByParentCodeAndFunctionCodePage(pageable, parentCode, functionCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan：mdm_function_sub_button 、mdm_button 、 mdm_icon
   * 根据 菜单，页面模板 查询 按钮信息（含图标）
   * 为findByParentCodeAndFunctionCode 提供不分页接口
   * @param parentCode
   * @param functionCode
   * @return
   */
  @ApiOperation("根据 菜单，页面模板 查询 按钮信息（含图标）不分页")
  @GetMapping("/findByParentCodeAndFunctionCode")
  public Result<List<ButtonConfigVo> > findByParentCodeAndFunctionCode( String parentCode, String functionCode) {
    try {
      List<ButtonConfigVo> list = this.buttonConfigVoService.findByParentCodeAndFunctionCode(parentCode, functionCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * hefan：from mdm_function_sub_button a join mdm_button left join mdm_icon c
   *  根据 mdm_function_sub_button的id 查询 按钮信息（含图标）
   * @param id
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
  })
  @ApiOperation("根据 mdm_function_sub_button的id 查询 按钮信息（含图标）")
  @GetMapping("/findById")
  public Result<ButtonConfigVo> findById(@RequestParam("id") String id) {
    try {
      ButtonConfigVo buttonConfigVo = this.buttonConfigVoService.findById(id);
      return Result.ok(buttonConfigVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
