package com.biz.crm.mdm.business.table.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.service.FunctionSubButtonService;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubButtonDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * functionSub与button的关联表
 *
 * @author hefan
 */
@Api(tags = "页面引擎：FunctionSubButton：functionSub与button的关联表")
@Slf4j
@RestController
@RequestMapping("/v1/table/functionSubButton")
public class FunctionSubButtonController {

  @Autowired(required = false)
  private FunctionSubButtonService functionSubButtonService;

  /**
   * MdmFunctionSubButtonEntity 新增操作
   *
   * @param functionSubButtonDto
   * @return
   */
  @ApiOperation("功能列表添加按钮")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody @ApiParam(name = "functionSubButtonDto", value = "功能列表与按钮关联表DTO") FunctionSubButtonDto functionSubButtonDto) {
    try {
      MdmFunctionSubButtonEntity current = this.functionSubButtonService.create(functionSubButtonDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * MdmFunctionSubButtonEntity 根据id集合删除
   *
   * @param ids
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "按钮id集合", required = true, paramType = "body")
  })
  @ApiOperation("功能列表按钮删除")
  @DeleteMapping("/deleteByIdIn")
  public Result<?> deleteByIdIn(@RequestBody @ApiParam(name = "ids", value = "id集合") List<String> ids) {
    try {
      this.functionSubButtonService.deleteByIdIn(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 code 查询
   *
   * @param code
   * @return
   */
  @ApiOperation("根据 code 查询")
  @GetMapping("/findByCode")
  public Result<MdmFunctionSubButtonEntity> findByButtonCode(@RequestParam @ApiParam(name = "code", value = "按钮编码") String code) {
    try {
      MdmFunctionSubButtonEntity entity = this.functionSubButtonService.findByCode(code);
      return Result.ok(entity);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
