package com.biz.crm.mdm.business.table.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.local.controller.ColumnConfigSelectVoController;
import com.biz.crm.mdm.business.table.local.controller.ColumnConfigVoController;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmColumnConfigBatchReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmColumnConfigReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmColumnConfigRespVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmColumnExportRespVo;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigBatchCreateDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPaginationDto;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigSelectVo;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/**
 * 字段配置
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */
@Slf4j
@RestController
@RequestMapping("/mdmcolumnconfig")
@Api(tags = "字段配置")
@PropertySource("classpath:bootstrap.yml")//读取application.yml文件
public class MdmColumnConfigController {

  @Autowired(required = false)
  private ColumnConfigVoController columnConfigVoController;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * hefan: 分页 动态 条件 查询
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation(value = "查询列表")
  @PostMapping("/list")
  public Result<PageResult<MdmColumnConfigRespVo>> list(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    PageRequest of = PageRequest.of(mdmColumnConfigReqVo.getPageNum(), mdmColumnConfigReqVo.getPageSize());
    ColumnConfigPaginationDto columnConfigPaginationDto = this.nebulaToolkitService.copyObjectByBlankList(mdmColumnConfigReqVo, ColumnConfigPaginationDto.class, HashSet.class, LinkedList.class);
    Result<Page<ColumnConfigVo>> result = this.columnConfigVoController.findByCondition(of, columnConfigPaginationDto);
    Page<ColumnConfigVo> result1 = result.getResult();
    List<ColumnConfigVo> records = result1.getRecords();
    List<MdmColumnConfigRespVo> mdmFunctionSubRespVos = (List<MdmColumnConfigRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, ColumnConfigVo.class, MdmColumnConfigRespVo.class, HashSet.class, LinkedList.class);
    PageResult<MdmColumnConfigRespVo> build = PageResult.<MdmColumnConfigRespVo>builder()
        .data(mdmFunctionSubRespVos)
        .count(result1.getTotal())
        .build();
    return Result.ok(build);
  }

  /**
   * hefan: 根据parentCode、functionCode 查询，并按照 formorder 排序
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation("字段配置列表")
  @PostMapping("/list_condition")
  public Result<List<MdmColumnConfigRespVo>> listCondition(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    Result<List<ColumnConfigVo>> result = this.columnConfigVoController.findByParentCodeAndFunctionCodeOrderByFormorder(mdmColumnConfigReqVo.getParentCode(), mdmColumnConfigReqVo.getFunctionCode());
    List<ColumnConfigVo> records = result.getResult();
    List<MdmColumnConfigRespVo> mdmFunctionSubRespVos = (List<MdmColumnConfigRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, ColumnConfigVo.class, MdmColumnConfigRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmFunctionSubRespVos);
  }

  /**
   * hefan: 根据 动态条件：parentCode，functionCode，field 查询 一条数据
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation(value = "查询")
  @PostMapping("/query")
  public Result<MdmColumnConfigRespVo> query(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    String parentCode = mdmColumnConfigReqVo.getParentCode();
    String functionCode = mdmColumnConfigReqVo.getFunctionCode();
    String field = mdmColumnConfigReqVo.getField();
    Result<ColumnConfigVo> result = this.columnConfigVoController.findByParentCodeAndFunctionCodeAndField(parentCode, functionCode, field);
    MdmColumnConfigRespVo respVo = this.nebulaToolkitService.copyObjectByBlankList(result.getResult(), MdmColumnConfigRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(respVo);
  }

  /**
   * hefan: 新增 column_config，并删除 字段配置个性设置
   *
   * @param mdmColumnConfigBatchReqVo
   * @return
   */
  @ApiOperation("批量新增")
  @PostMapping("/save_batch")
  public Result<?> saveBatch(@RequestBody MdmColumnConfigBatchReqVo mdmColumnConfigBatchReqVo) {
    ColumnConfigBatchCreateDto columnConfigBatchCreateDto = this.nebulaToolkitService.copyObjectByBlankList(mdmColumnConfigBatchReqVo, ColumnConfigBatchCreateDto.class, HashSet.class, LinkedList.class);
    this.columnConfigVoController.createByColumnConfigBatchCreateDto(columnConfigBatchCreateDto);
    return Result.ok();
  }

  /**
   * hefan: 删除旧的后新增，并删除个性化字段配置。
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<?> save(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    ColumnConfigDto columnConfigDto = this.nebulaToolkitService.copyObjectByBlankList(mdmColumnConfigReqVo, ColumnConfigDto.class, HashSet.class, LinkedList.class);
    this.columnConfigVoController.createByColumnConfigDto(columnConfigDto);
    return Result.ok();
  }

  /**
   * hefan: 修改，并删除个性化字段配置
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<?> update(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    ColumnConfigDto columnConfigDto = this.nebulaToolkitService.copyObjectByBlankList(mdmColumnConfigReqVo, ColumnConfigDto.class, HashSet.class, LinkedList.class);
    this.columnConfigVoController.updateByColumnConfigDto(columnConfigDto);
    return Result.ok("修改成功");
  }

  /**
   * hefan: 根据ID集合批量删除，并删除了一条column_config信息下的个性化字段配置
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation(value = "删除")
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    this.columnConfigVoController.deleteByIdIn(mdmColumnConfigReqVo.getIds());
    return Result.ok("删除成功");
  }

  /**
   * hefan: 根据 ID集合  启用
   *
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation(value = "启用")
  @PostMapping("/enable")
  public Result<?> enable(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    this.columnConfigVoController.enableByIdIn(mdmColumnConfigReqVo.getIds());
    return Result.ok("启用成功");
  }

  @Autowired(required = false)
  private ColumnConfigSelectVoController columnConfigSelectVoController;

  /**
   * hefan:
   * 根据 parentCode functionCode 【columnExport】查询 字段配置
   * fixme: 原crm的补丁
   * @param mdmColumnConfigReqVo
   * @return
   */
  @ApiOperation("字段下拉框")
  @PostMapping("/columnSelect")
  public Result<List<MdmColumnExportRespVo>> columnSelect(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
    Result<List<ColumnConfigSelectVo>> result = this.columnConfigSelectVoController.findByParentCodeAndFunctionCodeAndColumnExportOpt(mdmColumnConfigReqVo.getParentCode(), mdmColumnConfigReqVo.getFunctionCode(), mdmColumnConfigReqVo.getColumnExport());
    List<MdmColumnExportRespVo> list = (List<MdmColumnExportRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(result.getResult(), ColumnConfigSelectVo.class, MdmColumnExportRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(list);
  }


}
