package com.biz.crm.mdm.business.table.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.local.controller.ColumnConfigPersonalVoController;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmColumnConfigPersonalBatchReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmColumnConfigPersonalRespVo;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 字段配置个性设置
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@Slf4j
@RestController
@RequestMapping("/mdmColumnConfigPersonalController")
@Api(tags = "字段配置个性设置")
public class MdmColumnConfigPersonalController {

  @Autowired(required = false)
  private ColumnConfigPersonalVoController columnConfigPersonalVoController;

  /**
   * hefan:
   * 入参： parentCode functionCode 当前登陆人的positionCode
   * 返回：根据 个性化配置 过滤后的columnConfig
   *
   * @param reqVo
   * @return
   */
  @ApiOperation(value = "查询个性设置字段列表")
  @PostMapping("/findColumnConfigPersonalList")
  public Result<List<MdmColumnConfigPersonalRespVo>> findColumnConfigPersonalList(@RequestBody MdmColumnConfigPersonalBatchReqVo reqVo) {
    return Result.error("请用新接口：Get：/v1/table/columnConfigPersonal/findByParentCodeAndFunctionCode");
  }

  /**
   * hefan: 保存个性化配置
   *
   * @param reqVo
   * @return
   */
  @ApiOperation(value = "保存个性设置")
  @PostMapping("/saveColumnConfigPersonal")
  public Result saveColumnConfigPersonal(@RequestBody MdmColumnConfigPersonalBatchReqVo reqVo) {
    columnConfigPersonalVoController.createByColumnConfigPersonalBatchDto(new ColumnConfigPersonalBatchDto());
    return Result.error("请用新接口：Post：/v1/table/columnConfigPersonal");
  }

  /**
   * hefan:
   *  根据 parentCode functionCode 当前登陆人的positionCode 删除 个性设置
   * @param reqVo
   * @return
   */
  @ApiOperation(value = "删除个性设置")
  @PostMapping("/deleteColumnConfigPersonal")
  public Result deleteColumnConfigPersonal(@RequestBody MdmColumnConfigPersonalBatchReqVo reqVo) {
    return Result.error("请用新接口：delete：/v1/table/columnConfigPersonal/deleteByParentCodeAndFunctionCode");
  }


}
