package com.biz.crm.mdm.business.table.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.local.controller.ButtonConfigVoController;
import com.biz.crm.mdm.business.table.local.controller.FunctionSubButtonController;
import com.biz.crm.mdm.business.table.local.controller.FunctionSubController;
import com.biz.crm.mdm.business.table.local.controller.FunctionSubVoController;
import com.biz.crm.mdm.business.table.local.controller.PermissionObjVoController;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmFunctionSubButtonReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmFunctionSubReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmPermissionObjReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmButtonConfigRespVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmFunctionSubRespVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmPermissionObjRespVo;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubButtonDto;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubDto;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubPaginationDto;
import com.biz.crm.mdm.business.table.sdk.dto.PermissionObjDto;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import com.biz.crm.mdm.business.table.sdk.vo.FunctionSubVo;
import com.biz.crm.mdm.business.table.sdk.vo.PermissionObjVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 下级菜单表
 *
 * @author hefan
 */
@Slf4j
@RestController
@RequestMapping("/mdmfunctionsub")
@Api(tags = "功能列表")
public class MdmFunctionSubController {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private FunctionSubVoController functionSubVoController;

  @Autowired(required = false)
  private FunctionSubController functionSubController;

  @Autowired(required = false)
  private PermissionObjVoController permissionObjVoController;

  @Autowired(required = false)
  private FunctionSubButtonController functionSubButtonController;

  /**
   * hefan：MdmFunctionSubButtonEntity 新增操作
   *
   * @param mdmFunctionSubButtonReqVo
   * @return
   */
  @ApiOperation("功能列表添加按钮")
  @PostMapping("/buttonSetUp")
  public Result<?> buttonSetUp(@RequestBody MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
    FunctionSubButtonDto functionSubButtonDto = this.nebulaToolkitService.copyObjectByBlankList(mdmFunctionSubButtonReqVo, FunctionSubButtonDto.class, HashSet.class, LinkedList.class);
    return functionSubButtonController.create(functionSubButtonDto);
  }

  /**
   * hefan: MdmFunctionSubButtonEntity 根据id集合删除
   *
   * @param ids
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "按钮id集合", required = true, paramType = "body")
  })
  @ApiOperation("功能列表按钮删除")
  @PostMapping("/buttonRemove")
  public Result<?> buttonRemove(@RequestBody List<String> ids) {
    this.functionSubButtonController.deleteByIdIn(ids);
    return Result.ok();
  }

  /**
   * hefan: 根据 上级菜单编码  下级菜单编码 查询已配置的权限对象
   */
  @ApiOperation("根据列表编码和菜单编码查询已配置的权限对象")
  @PostMapping("/objList")
  public Result<List<MdmPermissionObjRespVo>> objList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    String parentCode = mdmFunctionSubReqVo.getParentCode();
    String functionCode = mdmFunctionSubReqVo.getFunctionCode();
    Result<List<PermissionObjVo>> result = this.permissionObjVoController.findByParentCodeAndFunctionCode(parentCode, functionCode);
    List<PermissionObjVo> permissionObjVos = result.getResult();
    List<MdmPermissionObjRespVo> mdmPermissionObjRespVos = (List<MdmPermissionObjRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(permissionObjVos, PermissionObjVo.class, MdmPermissionObjRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmPermissionObjRespVos);
  }

  /**
   * hefan:权限对象范围列表保存
   *
   * @param mdmPermissionObjReqVo
   * @return
   */
  @ApiOperation("权限对象范围列表保存")
  @PostMapping("/saveObj")
  public Result<?> saveObj(@RequestBody MdmPermissionObjReqVo mdmPermissionObjReqVo) {
    List<MdmPermissionObjRespVo> mdmPermissionObjRespVos = mdmPermissionObjReqVo.getMdmPermissionObjRespVos();
    List<String> collect = mdmPermissionObjRespVos.stream()
        .filter(x -> x != null && BooleanEnum.TRUE.getNumStr().equals(x.getSelect()))
        .map(MdmPermissionObjRespVo::getPermissionObjCode)
        .collect(Collectors.toList());
    PermissionObjDto permissionObjDto = new PermissionObjDto();
    permissionObjDto.setParentCode(mdmPermissionObjReqVo.getParentCode());
    permissionObjDto.setFunctionCode(mdmPermissionObjReqVo.getFunctionCode());
    permissionObjDto.setPermissionObjCodes(collect);
    permissionObjVoController.create(permissionObjDto);
    return Result.ok();
  }

  /**
   * hefan: 动态查询function_sub
   *
   * @param mdmFunctionSubReqVo
   * @return
   */
  @ApiOperation("根据上级编码查询功能列表")
  @PostMapping("/sub_list")
  public Result<Collection<MdmFunctionSubRespVo>> findSubList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    FunctionSubDto functionSubDto = this.nebulaToolkitService.copyObjectByBlankList(mdmFunctionSubReqVo, FunctionSubDto.class, HashSet.class, LinkedList.class);
    Result<List<FunctionSubVo>> result = this.functionSubVoController.findByFunctionSubDto(functionSubDto);
    Collection<MdmFunctionSubRespVo> mdmFunctionSubRespVos = this.nebulaToolkitService.copyCollectionByBlankList(result.getResult(), FunctionSubVo.class, MdmFunctionSubRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmFunctionSubRespVos);
  }

  /**
   * hefan: 分页-动态查询function_sub
   *
   * @param mdmFunctionSubReqVo
   * @return
   */
  @ApiOperation("根据上级编码查询功能分页列表")
  @PostMapping("/findSubPage")
  public Result<PageResult<MdmFunctionSubRespVo>> findSubPage(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    PageRequest of = PageRequest.of(mdmFunctionSubReqVo.getPageNum(), mdmFunctionSubReqVo.getPageSize());
    FunctionSubPaginationDto functionSubPaginationDto = this.nebulaToolkitService.copyObjectByBlankList(mdmFunctionSubReqVo, FunctionSubPaginationDto.class, HashSet.class, LinkedList.class);
    Result<Page<FunctionSubVo>> result = functionSubVoController.findByCondition(of, functionSubPaginationDto);
    Page<FunctionSubVo> result1 = result.getResult();
    List<FunctionSubVo> records = result1.getRecords();
    List<MdmFunctionSubRespVo> mdmFunctionSubRespVos = (List<MdmFunctionSubRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, FunctionSubVo.class, MdmFunctionSubRespVo.class, HashSet.class, LinkedList.class);
    PageResult<MdmFunctionSubRespVo> build = PageResult.<MdmFunctionSubRespVo>builder()
        .data(mdmFunctionSubRespVos)
        .count(result1.getTotal())
        .build();
    return Result.ok(build);
  }

  /**
   * hefan: 根据 ParentCode FunctionCode 查询 一条functionSub数据
   *
   * @param mdmFunctionSubReqVo
   * @return
   */
  @ApiOperation("根据菜单编码与功能编码查询")
  @PostMapping("/functionSubSearch")
  public Result<MdmFunctionSubRespVo> functionSubSearch(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    Result<FunctionSubVo> oneByParentCodeAndFunctionCode = this.functionSubVoController.findOneByParentCodeAndFunctionCode(mdmFunctionSubReqVo.getParentCode(), mdmFunctionSubReqVo.getFunctionCode());
    FunctionSubVo result = oneByParentCodeAndFunctionCode.getResult();
    MdmFunctionSubRespVo mdmFunctionSubRespVo = this.nebulaToolkitService.copyObjectByBlankList(result, MdmFunctionSubRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmFunctionSubRespVo);
  }

  /**
   * hefan: 根据ID查询一条
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "查询")
  @GetMapping("/query")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
  })
  public Result<MdmFunctionSubRespVo> query(@RequestParam(value = "id", required = false) String id) {
    Result<FunctionSubVo> findById = this.functionSubVoController.findById(id);
    FunctionSubVo result = findById.getResult();
    MdmFunctionSubRespVo mdmFunctionSubRespVo = null;
    if (Objects.nonNull(result)) {
      mdmFunctionSubRespVo = this.nebulaToolkitService.copyObjectByBlankList(result, MdmFunctionSubRespVo.class, HashSet.class, LinkedList.class);
    }
    return Result.ok(mdmFunctionSubRespVo);
  }

  /**
   * hefan: 根据ID，FunctionCode 查询一条信息
   *
   * @param mdmFunctionSubReqVo
   * @return
   */
  @ApiOperation("条件查询")
  @PostMapping("/queryCondition")
  public Result<MdmFunctionSubRespVo> queryCondition(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    Result<FunctionSubVo> voResult = this.functionSubVoController.findByIdAndFunctionCode(mdmFunctionSubReqVo.getId(), mdmFunctionSubReqVo.getFunctionCode());
    FunctionSubVo result = voResult.getResult();
    MdmFunctionSubRespVo mdmFunctionSubRespVo = null;
    if (Objects.nonNull(result)) {
      mdmFunctionSubRespVo = this.nebulaToolkitService.copyObjectByBlankList(result, MdmFunctionSubRespVo.class, HashSet.class, LinkedList.class);
    }
    return Result.ok(mdmFunctionSubRespVo);
  }

  /**
   * hefan: function_sub 新增
   *
   * @param mdmFunctionSubReqVo
   * @return
   */
  @ApiOperation(value = "function_sub 新增")
  @PostMapping("/save")
  public Result save(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    MdmFunctionSubEntity mdmFunctionSubEntity = this.nebulaToolkitService.copyObjectByBlankList(mdmFunctionSubReqVo, MdmFunctionSubEntity.class, HashSet.class, LinkedList.class);
    this.functionSubController.create(mdmFunctionSubEntity);
    return Result.ok();
  }

  /**
   * fixme: 修改数据，如果修改了functionCode，同时修改column_config、sub_button关联
   * 更新
   */
  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result update(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    MdmFunctionSubEntity functionSubEntity = this.nebulaToolkitService.copyObjectByBlankList(mdmFunctionSubReqVo, MdmFunctionSubEntity.class, HashSet.class, LinkedList.class);
    this.functionSubController.update(functionSubEntity);
    return Result.ok("修改成功");
  }

  /**
   * hefan: 这个方法内部本身就是写法错误的
   * *      删了functionSub
   * *      删了functionSubButton
   * *      删了columnConfig
   * *      清除了parentCode以下的缓存
   */
  @ApiOperation(value = "删除")
  @PostMapping("/delete")
  public Result delete(@RequestBody List<String> ids) {
    this.functionSubController.deleteByIdIn(ids);
    return Result.ok("删除成功");
  }

  /**
   * hefan: 根据ID集合 修改 启用状态
   * 启用
   */
  @ApiOperation(value = "启用")
  @PostMapping("/enable")
  public Result enable(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    this.functionSubController.enableByIdIn(mdmFunctionSubReqVo.getIds());
    return Result.ok("启用成功");
  }

  /**
   * hefan: 根据ID集合 修改 禁用状态
   * 禁用
   */
  @ApiOperation(value = "禁用")
  @PostMapping("/disable")
  public Result disable(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    this.functionSubController.disableByIdIn(mdmFunctionSubReqVo.getIds());
    return Result.ok("禁用成功");
  }

  @Autowired(required = false)
  private ButtonConfigVoController buttonConfigVoController;

  /**
   * hefan: 主查询：mdm_function_sub_button ；join：mdm_button 、 mdm_icon
   * 查询到其他模块了。
   *
   * @param mdmFunctionSubReqVo
   * @return
   */
  @ApiOperation("功能列表查询按钮")
  @PostMapping("/buttonList")
  public Result<List<MdmButtonConfigRespVo>> buttonList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo) {
    Result<List<ButtonConfigVo>> result = buttonConfigVoController.findByParentCodeAndFunctionCode(mdmFunctionSubReqVo.getParentCode(), mdmFunctionSubReqVo.getFunctionCode());
    List<MdmButtonConfigRespVo> mdmButtonConfigRespVos = (List<MdmButtonConfigRespVo>) this.nebulaToolkitService.copyCollectionByBlankList(result.getResult(), ButtonConfigVo.class, MdmButtonConfigRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmButtonConfigRespVos);
  }

  /**
   * hefan：from mdm_function_sub_button a join mdm_button left join mdm_icon c
   *  查询到其他模块了
   * @param id
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
  })
  @ApiOperation("功能列表查询按钮")
  @GetMapping("/buttonQuery")
  public Result<MdmButtonConfigRespVo> buttonQuery(@RequestParam("id") String id) {
    Result<ButtonConfigVo> result = buttonConfigVoController.findById(id);
    MdmButtonConfigRespVo mdmButtonConfigRespVo = this.nebulaToolkitService.copyObjectByBlankList(result.getResult(), MdmButtonConfigRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmButtonConfigRespVo);
  }

}
