package com.biz.crm.mdm.business.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * hefan：个性设置（个性化配置）
 *
 * 字段配置个性设置实体类
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmColumnConfigPersonalEntity", description = "字段配置个性设置实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_column_config_personal`", comment = "字段配置个性设置实体类")
@TableName("mdm_column_config_personal")
@Table(name = "`mdm_column_config_personal`", indexes = {
    @Index(name = "idx_parent_code_function_code_position_code", columnList = "parent_code,function_code,position_code"),
})
public class MdmColumnConfigPersonalEntity extends TenantFlagOpEntity {

  /**
   * 当前职位编码
   */
  @ApiModelProperty("当前职位编码")
  @Column(name = "position_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 当前职位编码 '")
  private String positionCode;

  /**
   * 上级菜单编码
   */
  @ApiModelProperty("上级菜单编码")
  @Column(name = "parent_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 上级菜单编码 '")
  private String parentCode;

  /**
   * 功能菜单编码
   */
  @ApiModelProperty("功能菜单编码")
  @Column(name = "function_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 功能菜单编码 '")
  private String functionCode;

  /**
   * 属性
   */
  @ApiModelProperty("属性")
  @Column(name = "field", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 属性 '")
  private String field;

  /**
   * 显示模式：1显示，0隐藏
   */
  @ApiModelProperty("示模式：1显示，0隐藏")
  @Column(name = "visible", nullable = true, columnDefinition = "bit(1) COMMENT ' 显示模式：1显示，0隐藏 '")
  private Boolean visible;

  /**
   * 顺序
   */
  @ApiModelProperty("顺序")
  @Column(name = "form_order", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 顺序 '")
  private String formOrder;

}
