package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.local.service.FunctionSubService;
import com.biz.crm.mdm.business.table.sdk.constant.PageEngineConstant;
import com.biz.crm.mdm.business.table.sdk.vo.PageEngineCompetenceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.service.CompetenceVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author hefan
 */
@Service
public class FunctionSubServiceImpl implements FunctionSubService {

  @Autowired(required = false)
  private FunctionSubRepository functionSubRepository;
  @Autowired(required = false)
  private FunctionSubButtonRepository functionSubButtonRepository;
  @Autowired(required = false)
  private ColumnConfigRepository columnConfigRepository;

  @Autowired(required = false)
  private CompetenceVoService competenceVoService;

  @Transactional
  @Override
  public MdmFunctionSubEntity create(MdmFunctionSubEntity mdmFunctionSubEntity) {
    this.createValidation(mdmFunctionSubEntity);
    mdmFunctionSubEntity.setTenantCode(TenantUtils.getTenantCode());
    String code = StringUtils.join(mdmFunctionSubEntity.getParentCode(), PageEngineConstant.JOINT_MARK, mdmFunctionSubEntity.getFunctionCode());
    mdmFunctionSubEntity.setCode(code);
    this.functionSubRepository.save(mdmFunctionSubEntity);
    // fixme 原逻辑：清除页面配置缓存；实际：从redis中删除数据；当前处理：假装没有看见
    // 保存功能总控信息
    PageEngineCompetenceVo competenceVo = new PageEngineCompetenceVo();
    competenceVo.setType(PageEngineConstant.PAGE_ENGINE);
    competenceVo.setCode(code);
    competenceVo.setComment(mdmFunctionSubEntity.getRemark());
    competenceVo.setViewItem(Integer.valueOf(BooleanEnum.FALSE.getNumStr()));
    String parentCode = mdmFunctionSubEntity.getParentCode();
    competenceVo.setParentCode(parentCode);
    competenceVoService.create(competenceVo);
    return mdmFunctionSubEntity;
  }

  @Transactional
  @Override
  public void update(MdmFunctionSubEntity mdmFunctionSubEntity) {
    MdmFunctionSubEntity entityDb = this.updateValidation(mdmFunctionSubEntity);
    mdmFunctionSubEntity.setTenantCode(TenantUtils.getTenantCode());
    this.functionSubRepository.updateById(mdmFunctionSubEntity);
    // 如果修改了functionCode: 入参与原数据库内的比较
    String functionCode = mdmFunctionSubEntity.getFunctionCode();
    String parentCode = mdmFunctionSubEntity.getParentCode();
    String functionCodeDB = entityDb.getFunctionCode();
    if (functionCode.equals(functionCodeDB)) {
      return;
    }
    this.functionSubButtonRepository.updateFunctionCodeByParentCodeAndFunctionCode(parentCode, functionCodeDB, functionCode);
    this.columnConfigRepository.updateFunctionCodeByParentCodeAndFunctionCode(parentCode, functionCodeDB, functionCode);
    // fixme 原逻辑：清除页面配置缓存；实际：从redis中删除数据；当前处理：假装没有看见
    CompetenceVo competenceVo = competenceVoService.findByCompetenceCode(entityDb.getCode());
    String code = StringUtils.join(mdmFunctionSubEntity.getParentCode(), PageEngineConstant.JOINT_MARK, mdmFunctionSubEntity.getFunctionCode());
    competenceVo.setCode(code);
    competenceVo.setType(PageEngineConstant.PAGE_ENGINE);
    competenceVo.setComment(mdmFunctionSubEntity.getRemark());
    competenceVo.setViewItem(Integer.valueOf(BooleanEnum.FALSE.getNumStr()));
    competenceVo.setParentCode(parentCode);
    competenceVoService.update(competenceVo);
  }

  @Transactional
  @Override
  public void deleteByIdIn(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "id集合不能为空");
    // 根据 id集合 查询 parentCode，functionCode
    List<MdmFunctionSubEntity> list = this.functionSubRepository.findByIdIn(ids);
    Validate.isTrue(!CollectionUtils.isEmpty(list), "数据库内不存在，选中的数据");
    // 从查询结果，收集parentCode
    List<String> parentCodeList = list.stream()
        .filter(x -> x != null && !StringUtils.isEmpty(x.getParentCode()))
        .map(MdmFunctionSubEntity::getParentCode)
        .collect(Collectors.toList());
    // 从查询结果，收集functionCode
    List<String> functionCodeList = list.stream()
        .filter(x -> x != null && !StringUtils.isEmpty(x.getFunctionCode()))
        .map(MdmFunctionSubEntity::getFunctionCode)
        .collect(Collectors.toList());
    // --两个集合都不为空
    if (!CollectionUtils.isEmpty(parentCodeList) && !CollectionUtils.isEmpty(functionCodeList)) {
      //按钮删除
      this.functionSubButtonRepository.deleteByParentCodeInAndFunctionCodeIn(parentCodeList, functionCodeList);
      //字段删除
      this.columnConfigRepository.deleteByParentCodeInAndFunctionCodeIn(parentCodeList, functionCodeList);
    }
    // fixme：原逻辑：取出一条，去除上级菜单，清除了菜单级别以下的缓存？？？
    this.functionSubRepository.removeByIdsAndTenantCode(ids,TenantUtils.getTenantCode());
    // 从查询结果，收集 code
    List<String> codeList = list.stream()
        .filter(x -> x != null && !StringUtils.isEmpty(x.getCode()))
        .map(MdmFunctionSubEntity::getCode)
        .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(codeList)) {
      return;
    }
    // 批量删除功能总控侧数据
    for (String code : codeList) {
      competenceVoService.deleteByCode(code);
    }
  }

  @Transactional
  @Override
  public void enableByIdIn(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "id集合不能为空");
    this.functionSubRepository.updateEnableStatusByIdIn(ids, EnableStatusEnum.ENABLE.getCode());
  }

  @Transactional
  @Override
  public void disableByIdIn(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "id集合不能为空");
    this.functionSubRepository.updateEnableStatusByIdIn(ids, EnableStatusEnum.DISABLE.getCode());
  }

  /**
   * 修改时，校验
   *
   * @param mdmFunctionSubEntity
   */
  private MdmFunctionSubEntity updateValidation(MdmFunctionSubEntity mdmFunctionSubEntity) {
    Validate.notNull(mdmFunctionSubEntity, "修改时，模型对象为空");
    String functionCode = mdmFunctionSubEntity.getFunctionCode();
    Validate.notBlank(functionCode, "功能编码不能为空");
    String functionName = mdmFunctionSubEntity.getFunctionName();
    Validate.notBlank(functionName, "名称不能为空");
    String id = mdmFunctionSubEntity.getId();
    Validate.notBlank(id, "主键id不能为空");
    String parentCode = mdmFunctionSubEntity.getParentCode();
    // 根据ID查询
    MdmFunctionSubEntity entity = this.functionSubRepository.findById(id);
    Validate.notNull(entity, "功能列表不存在");
    // fixme: 原逻辑：使用parentCode查询菜单是否存在
    // 用parentCode，functionCode 查询，并过滤掉等于上面id的。
    List<MdmFunctionSubEntity> functionSubList = this.functionSubRepository.findIdByParentCodeAndFunctionCode(parentCode, mdmFunctionSubEntity.getFunctionCode());
    long count = functionSubList.stream().filter(x -> !id.equals(x.getId())).count();
    // 过滤完后，必须为0才往下执行
    Validate.isTrue(count < 1, "功能编码已存在");
    return entity;
  }

  /**
   * 创建时校验
   *
   * @param mdmFunctionSubEntity
   */
  private void createValidation(MdmFunctionSubEntity mdmFunctionSubEntity) {
    Validate.notBlank(mdmFunctionSubEntity.getParentCode(), "菜单编码不能为空");
    Validate.notBlank(mdmFunctionSubEntity.getFunctionCode(), "功能编码不能为空");
    // fixme: 原逻辑：使用parentCode查询菜单是否存在
    // 校验 功能编码 唯一
    Integer count = this.functionSubRepository.countByParentCodeAndFunctionCode(mdmFunctionSubEntity.getParentCode(), mdmFunctionSubEntity.getFunctionCode());
    Assert.isTrue(count == null || count < 1, "功能编码已存在");

  }
}
