/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.local.service.ColumnConfigPersonalService;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigBatchCreateDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPaginationDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ColumnConfigVoServiceImpl
implements ColumnConfigVoService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ColumnConfigRepository columnConfigRepository;
    @Autowired(required=false)
    private ColumnConfigPersonalService columnConfigPersonalService;
    private static Pattern pattern = Pattern.compile("[\\u4E00-\\u9FA5]+");

    public Page<ColumnConfigVo> findByCondition(Pageable pageable, ColumnConfigPaginationDto columnConfigPaginationDto) {
        if (Objects.isNull(columnConfigPaginationDto)) {
            return null;
        }
        return this.columnConfigRepository.findByCondition(pageable, columnConfigPaginationDto);
    }

    public List<ColumnConfigVo> findByParentCodeAndFunctionCodeOrderByFormorder(String parentCode, String functionCode) {
        if (StringUtils.isEmpty((CharSequence)parentCode) || StringUtils.isEmpty((CharSequence)functionCode)) {
            return Lists.newLinkedList();
        }
        List<MdmColumnConfigEntity> list = this.columnConfigRepository.findByParentCodeAndFunctionCode(parentCode, functionCode);
        int oneHundred = 100;
        if (!CollectionUtils.isEmpty(list)) {
            list = list.stream().sorted(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder()).map(Integer::valueOf).orElse(oneHundred))).collect(Collectors.toList());
        }
        List columnConfigVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, MdmColumnConfigEntity.class, ColumnConfigVo.class, HashSet.class, LinkedList.class, new String[0]);
        return columnConfigVos;
    }

    public ColumnConfigVo findByParentCodeAndFunctionCodeAndField(String parentCode, String functionCode, String field) {
        MdmColumnConfigEntity one = this.columnConfigRepository.findByParentCodeAndFunctionCodeAndField(parentCode, functionCode, field);
        ColumnConfigVo columnConfigVo = (ColumnConfigVo)this.nebulaToolkitService.copyObjectByBlankList((Object)one, ColumnConfigVo.class, HashSet.class, LinkedList.class, new String[0]);
        return columnConfigVo;
    }

    @Transactional
    public void createByColumnConfigBatchCreateDto(ColumnConfigBatchCreateDto columnConfigBatchCreateDto) {
        this.createValidation(columnConfigBatchCreateDto);
        String parentCode = columnConfigBatchCreateDto.getParentCode();
        String functionCode = columnConfigBatchCreateDto.getFunctionCode();
        List mdmColumnConfigVos = columnConfigBatchCreateDto.getMdmColumnConfigVos();
        this.columnConfigRepository.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
        List mdmColumnConfigEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)mdmColumnConfigVos, ColumnConfigDto.class, MdmColumnConfigEntity.class, HashSet.class, LinkedList.class, new String[0]);
        for (MdmColumnConfigEntity entity : mdmColumnConfigEntities) {
            Validate.notBlank((CharSequence)entity.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            entity.setParentCode(parentCode);
            entity.setFunctionCode(functionCode);
            entity.setId(null);
        }
        this.columnConfigRepository.saveBatch(mdmColumnConfigEntities);
        this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
    }

    @Transactional
    public void createByColumnConfigDto(ColumnConfigDto columnConfigDto) {
        this.createValidation(columnConfigDto);
        this.columnConfigRepository.deleteByParentCodeAndFunctionCodeAndField(columnConfigDto.getParentCode(), columnConfigDto.getFunctionCode(), columnConfigDto.getField());
        MdmColumnConfigEntity entity = (MdmColumnConfigEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)columnConfigDto, MdmColumnConfigEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.columnConfigRepository.save((Object)entity);
        this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(columnConfigDto.getParentCode(), columnConfigDto.getFunctionCode());
    }

    @Transactional
    public void updateByColumnConfigDto(ColumnConfigDto columnConfigDto) {
        this.updateValidation(columnConfigDto);
        MdmColumnConfigEntity entity = (MdmColumnConfigEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)columnConfigDto, MdmColumnConfigEntity.class, HashSet.class, LinkedList.class, new String[0]));
        this.columnConfigRepository.updateById((Object)entity);
        this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(columnConfigDto.getParentCode(), columnConfigDto.getFunctionCode());
    }

    @Transactional
    public void deleteByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MdmColumnConfigEntity> list = this.columnConfigRepository.findByIdIn(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u8981\u5220\u9664\u7684\u4fe1\u606f", (Object[])new Object[0]);
        MdmColumnConfigEntity mdmColumnConfigEntity = list.get(0);
        String parentCode = mdmColumnConfigEntity.getParentCode();
        String functionCode = mdmColumnConfigEntity.getFunctionCode();
        if (!StringUtils.isEmpty((CharSequence)parentCode) && !StringUtils.isEmpty((CharSequence)functionCode)) {
            this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
        }
        this.columnConfigRepository.removeByIds(ids);
    }

    @Transactional
    public void enableByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String enableStatusCode = EnableStatusEnum.ENABLE.getCode();
        this.columnConfigRepository.updateEnableStatusByIdIn(ids, enableStatusCode);
    }

    public Collection<ColumnConfigVo> findByParentCode(String parentCode) {
        List<MdmColumnConfigEntity> list = this.columnConfigRepository.findByParentCode(parentCode);
        Collection columnConfigVos = this.nebulaToolkitService.copyCollectionByBlankList(list, MdmColumnConfigEntity.class, ColumnConfigVo.class, HashSet.class, LinkedList.class, new String[0]);
        return columnConfigVos;
    }

    public List<ColumnConfigVo> findByParent7Func9Formorder4TitleCN(String parentCode, String functionCode) {
        List<Object> collect = this.findByParentCodeAndFunctionCodeOrderByFormorder(parentCode, functionCode);
        Matcher matcher = pattern.matcher("");
        collect = collect.stream().filter(x -> {
            String title = x.getTitle();
            if (StringUtils.isBlank((CharSequence)title)) {
                return false;
            }
            matcher.reset(title);
            return matcher.find();
        }).collect(Collectors.toList());
        return collect;
    }

    private void updateValidation(ColumnConfigDto columnConfigDto) {
        Validate.notNull((Object)columnConfigDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)columnConfigDto.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)columnConfigDto.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)columnConfigDto.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validSearchAndExport(Collections.singletonList(columnConfigDto));
        String id = columnConfigDto.getId();
        Validate.notBlank((CharSequence)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MdmColumnConfigEntity entityDB = (MdmColumnConfigEntity)((Object)this.columnConfigRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entityDB), (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
    }

    private void createValidation(ColumnConfigDto columnConfigDto) {
        Validate.notNull((Object)columnConfigDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)columnConfigDto.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)columnConfigDto.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)columnConfigDto.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        columnConfigDto.setId(null);
        this.validSearchAndExport(Collections.singletonList(columnConfigDto));
    }

    private void createValidation(ColumnConfigBatchCreateDto columnConfigBatchCreateDto) {
        Validate.notNull((Object)columnConfigBatchCreateDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String parentCode = columnConfigBatchCreateDto.getParentCode();
        Validate.notBlank((CharSequence)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String functionCode = columnConfigBatchCreateDto.getFunctionCode();
        Validate.notBlank((CharSequence)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List mdmColumnConfigVos = columnConfigBatchCreateDto.getMdmColumnConfigVos();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)mdmColumnConfigVos) ? 1 : 0) != 0, (String)"\u65b0\u589e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet<String> set = new HashSet<String>(mdmColumnConfigVos.size());
        for (ColumnConfigDto mdmColumnConfigVo : mdmColumnConfigVos) {
            Validate.isTrue((boolean)set.add(mdmColumnConfigVo.getField()), (String)("\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5:" + mdmColumnConfigVo.getField()), (Object[])new Object[0]);
        }
        this.validSearchAndExport(mdmColumnConfigVos);
    }

    private void validSearchAndExport(List<ColumnConfigDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (ColumnConfigDto mdmColumnConfigReqVo : list) {
            if (mdmColumnConfigReqVo != null && BooleanEnum.TRUE.name().equalsIgnoreCase(mdmColumnConfigReqVo.getSearch())) {
                Validate.notBlank((CharSequence)mdmColumnConfigReqVo.getType(), (String)("\u5b57\u6bb5(" + mdmColumnConfigReqVo.getTitle() + ")\u5141\u8bb8\u67e5\u8be2\u9700\u8981\u914d\u7f6e\u63a7\u4ef6\u7c7b\u578b"), (Object[])new Object[0]);
            }
            if (!StringUtils.equals((CharSequence)BooleanEnum.TRUE.getNumStr(), (CharSequence)mdmColumnConfigReqVo.getColumnExport())) continue;
            Validate.notBlank((CharSequence)mdmColumnConfigReqVo.getTitle(), (String)("\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5:" + mdmColumnConfigReqVo.getField() + ",\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        }
    }
}

