package com.biz.crm.mdm.business.table.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigBatchCreateDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPaginationDto;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;

/**
 * @author hefan
 */
public interface ColumnConfigVoService {

  /**
   * 分页查询
   *
   * @param pageable
   * @param columnConfigPaginationDto
   * @return
   */
  Page<ColumnConfigVo> findByCondition(Pageable pageable, ColumnConfigPaginationDto columnConfigPaginationDto);

  /**
   * 根据parentCode、functionCode 查询，并按照 formorder 排序
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  List<ColumnConfigVo> findByParentCodeAndFunctionCodeOrderByFormorder(String parentCode, String functionCode);

  /**
   * 根据 parentCode，functionCode，field 查询 一条数据
   * @param parentCode
   * @param functionCode
   * @param field
   * @return
   */
  ColumnConfigVo findByParentCodeAndFunctionCodeAndField(String parentCode, String functionCode, String field);

  /**
   * 新增 column_config，并删除 字段配置个性设置
   * @param columnConfigBatchCreateDto
   */
  void createByColumnConfigBatchCreateDto(ColumnConfigBatchCreateDto columnConfigBatchCreateDto);

  /**
   * 删除旧的后新增，并删除个性化字段配置。
   * @param columnConfigDto
   */
  void createByColumnConfigDto(ColumnConfigDto columnConfigDto);

  /**
   * 修改，并删除个性化字段配置
   * @param columnConfigDto
   */
  void updateByColumnConfigDto(ColumnConfigDto columnConfigDto);

  /**
   * 根据ID集合批量删除，并删除了一条column_config信息下的个性化字段配置
   * @param ids
   */
  void deleteByIdIn(List<String> ids);

  /**
   * 根据ID集合，启用
   * @param ids
   */
  void enableByIdIn(List<String> ids);

  /**
   * 发现由父代码
   *
   * @param parentCode 父代码
   * @return {@link List}<{@link ColumnConfigVo}>
   */
  Collection<ColumnConfigVo> findByParentCode(String parentCode);
}
