package com.biz.crm.mdm.business.table.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubDto;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubPaginationDto;
import com.biz.crm.mdm.business.table.sdk.vo.FunctionSubVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author hefan
 */
public interface FunctionSubVoService {

  /**
   * 分页查询
   *
   * @param pageable
   * @param functionSubPaginationDto
   * @return
   */
  Page<FunctionSubVo> findByCondition(Pageable pageable, FunctionSubPaginationDto functionSubPaginationDto);

  /**
   * 动态查询 function_sub
   * @param functionSubDto
   * @return
   */
  List<FunctionSubVo> findByFunctionSubDto(FunctionSubDto functionSubDto);

  /**
   * 根据 ParentCode FunctionCode 查询 一条functionSub数据
   * @param parentCode
   * @param functionCode
   * @return
   */
  FunctionSubVo findOneByParentCodeAndFunctionCode(String parentCode, String functionCode);

  /**
   * 根据ID查询
   * @param id
   * @return
   */
  FunctionSubVo findById(String id);

  /**
   * 根据ID，FunctionCode 查询一条信息
   * @param id
   * @param functionCode
   * @return
   */
  FunctionSubVo findByIdAndFunctionCode(String id, String functionCode);
}
