package com.biz.crm.mdm.business.table.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 功能列表与按钮关联表DTO
 *
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FunctionSubButtonDto", description = "功能列表与按钮关联表DTO")
public class FunctionSubButtonDto {

  @ApiModelProperty("按钮编码")
  private String buttonCode;

  /**
   * 按钮名称
   */
  @ApiModelProperty("按钮名称")
  private String buttonName;

  @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
  private String buttonType;

  @ApiModelProperty("图标编码")
  private String iconCode;

  @ApiModelProperty("询问语")
  private String ask;

  @ApiModelProperty("功能查询地址")
  private String queryUrl;

  @ApiModelProperty("url")
  private String apiUrl;

  /**
   * api url 请求映射
   */
  @ApiModelProperty("apiUrlRequestMapping")
  private String apiUrlRequestMapping;

  @ApiModelProperty("按钮操作类型")
  private String buttonOperationType;

  @ApiModelProperty("上级菜单编码")
  private String parentCode;

  @ApiModelProperty("功能列表编码")
  private String functionCode;

  @ApiModelProperty("排序")
  private Integer buttonOrder;

  @ApiModelProperty("功能编码")
  private String doCode;

  @ApiModelProperty("显示模式：true显示，false隐藏")
  private Boolean visible;

  @ApiModelProperty("是否展示按钮：true显示，false隐藏")
  private Boolean showMode;

  @ApiModelProperty("导入按钮编码")
  private String configCode;

}
