package com.biz.crm.mdm.business.table.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * ButtonConfigVo: 含图标信息的按钮
 */
public interface ButtonConfigVoService {

  /**
   * 根据 菜单，页面模板 查询 按钮信息（含图标）
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  Page<ButtonConfigVo> findByParentCodeAndFunctionCodePage(Pageable pageable, String parentCode, String functionCode);

  /**
   * 根据 mdm_function_sub_button的id 查询 按钮信息（含图标）
   * @param id
   * @return
   */
  ButtonConfigVo findById(String id);

  /**
   * 根据 菜单，页面模板 查询 按钮信息（含图标）
   * @param parentCode
   * @param functionCode
   * @return
   */
  List<ButtonConfigVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode);
}
