package com.biz.crm.mdm.business.table.sdk.service;

import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;

import java.util.List;

/**
 * @author hefan
 */
public interface ColumnConfigPersonalVoService {

  /**
   * 入参： parentCode functionCode 当前登陆人的positionCode
   * 返回：根据 个性化配置 过滤后的columnConfig
   * 注意：该方法内部调用需要用户登录才能返回用户个性化设置数据
   * @param parentCode
   * @param functionCode
   * @return
   */
  List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode);

  /**
   * 保存个性化配置
   *
   * @param columnConfigPersonalBatchDto
   */
  void createByColumnConfigPersonalBatchDto(ColumnConfigPersonalBatchDto columnConfigPersonalBatchDto);

  /**
   * 根据 parentCode functionCode 当前登陆人的positionCode 删除 个性设置
   *
   * @param parentCode
   * @param functionCode
   */
  void deleteByParentCodeAndFunctionCode(String parentCode, String functionCode);

}
