package com.biz.crm.mdm.business.table.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 下级菜单表返回vo
 *
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "下级菜单表", description = "下级菜单表返回vo")
public class FunctionSubVo extends TenantFlagOpVo {

  /**
   * 功能编码 = parentCode + @ + functionCode
   */
  @ApiModelProperty("功能编码 = parentCode + @ + functionCode")
  private String code;

  @ApiModelProperty("下级菜单编码")
  private String functionCode;

  @ApiModelProperty("菜单类型")
  private String functionType;

  @ApiModelProperty("下级菜单名称")
  private String functionName;

  @ApiModelProperty("上级菜单编码")
  private String parentCode;

  @ApiModelProperty("url")
  private String apiUrl;

  /**
   * api url 请求映射
   */
  @ApiModelProperty("apiUrlRequestMapping")
  private String apiUrlRequestMapping;

  /**
   * 字段来源
   * （数据试图、或者其他）
   */
  @ApiModelProperty("configSource")
  private String configSource;

  /**
   * 字段来源名称
   * （数据试图、或者其他）
   */
  @ApiModelProperty("configSourceName")
  private String configSourceName;

  /**
   * 字段来源之子系统
   *
   */
  @ApiModelProperty("systemOfConfigSource")
  private String systemOfConfigSource;

  @ApiModelProperty("vo名称")
  private String voName;

}
