package com.biz.crm.mdm.business.terminal.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.feign.feign.TerminalClientVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalClientDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalClientVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalClientVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 经销商客户sdk实现
 *
 * @author songjingen
 */
@Service
public class TerminalClientVoServiceImpl implements TerminalClientVoService {

  @Autowired(required = false)
  private TerminalClientVoServiceFeign terminalClientVoServiceFeign;

  @Override
  public Page<TerminalClientVo> findChildrenPageByTerminalClientDto(Pageable pageable, TerminalClientDto dto) {
    return this.terminalClientVoServiceFeign.findChildrenPageByTerminalClientDto(pageable.getPageNumber(), pageable.getPageSize(), dto).getResult();
  }
}
