package com.biz.crm.mdm.business.terminal.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.feign.feign.TerminalVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 终端sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service("FeignTerminalVoServiceImpl")
public class TerminalVoServiceImpl implements TerminalVoService {

  @Autowired(required = false) private TerminalVoServiceFeign terminalVoServiceFeign;

  @Override
  public List<TerminalVo> findDetailsByIdsOrTerminalCodes(
      List<String> ids, List<String> terminalCodes) {
    ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
    terminalCodes = Optional.ofNullable(terminalCodes).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findDetailByIdsOrCodes(ids, terminalCodes).getResult();
  }

  @Override
  public Page<TerminalVo> findByTerminalPaginationDto(
      Pageable pageable, TerminalPaginationDto dto) {
    return this.terminalVoServiceFeign
        .findByTerminalPaginationDto(pageable.getPageNumber(), pageable.getPageSize(), dto)
        .getResult();
  }

  @Override
  public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
    return this.terminalVoServiceFeign.findByTerminalCodeSearchDto(dto).getResult();
  }

  @Override
  public TerminalVo create(TerminalDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public TerminalVo update(TerminalDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
    return this.terminalVoServiceFeign.findByTerminalQueryDto(dto).getResult();
  }

  @Override
  public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
    terminalCodeList = Optional.ofNullable(terminalCodeList).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findMainDetailsByTerminalCodes(terminalCodeList).getResult();
  }

  @Override
  public Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
    return this.terminalVoServiceFeign.findAllowSaleTerminalByOrgCodes(orgCodes).getResult();
  }
}
