package com.biz.crm.mdm.business.terminal.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.internal.TerminalTagVoFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 终端标签feign接口类
 *
 * @author songjingen
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalTagVoFeignImpl.class)
public interface TerminalTagVoFeign {

  /**
   * 通过终端编码查询标签列表
   *
   * @param terminalCodes
   * @return
   */
  @ApiOperation(value = "通过终端编码查询标签列表")
  @GetMapping(value = {"/v1/terminalTag/TerminalTagVo/findByTerminalCodes"})
  Result<List<TerminalTagVo>> findByTerminalCodes(@RequestParam("terminalCodes") Set<String> terminalCodes);
}
