package com.biz.crm.mdm.business.terminal.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.internal.TerminalVoServiceFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.dto.*;
import com.biz.crm.mdm.business.terminal.sdk.vo.CustomerTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 终端feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = TerminalVoServiceFeignImpl.class)
public interface TerminalVoServiceFeign {

  /**
   * 根据id或编码集合获取终端详情
   *
   * @param ids
   * @param codes
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findDetailByIdsOrCodes")
  Result<List<TerminalVo>> findDetailByIdsOrCodes(
          @RequestParam("ids") List<String> ids, @RequestParam("codes") List<String> codes);

  /**
   * 根据企业组织编码获取匹配的终端信息
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findByOrgCodes")
  Result<List<TerminalVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList);

  /**
   * 根据编码获取终端主信息+组织信息
   *
   * @param terminalCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findMainDetailsByTerminalCodes")
  Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
          @RequestParam("terminalCodeList") List<String> terminalCodeList);

  /**
   * 根据编码获取终端主信息+组织信息
   *
   * @param terminalCodeList
   * @return
   */
  @PostMapping("/v1/terminal/terminal/findMainDetailsByTerminalCodesUsePost")
  Result<List<TerminalVo>> findMainDetailsByTerminalCodesUsePost(
          @RequestBody List<String> terminalCodeList);

  /**
   * 根据终端编码集合获取终端主信息+联系人
   *
   * @param terminalCodeList
   * @return
   */
  @ApiOperation(value = "根据终端编码集合获取终端主信息+联系人")
  @PostMapping("/v1/terminal/terminal/findTerminalAndContactByTerminalCodes")
  Result<List<TerminalVo>> findTerminalAndContactByTerminalCodes(@RequestBody List<String> terminalCodeList);

  /**
   * 分页条件查询
   *
   * @param dto 参数dto
   * @return 终端分页信息
   */
  @ApiOperation(value = "分页条件查询")
  @GetMapping(value = {"/v1/terminal/terminal/findByTerminalPaginationDto"})
  Result<Page<TerminalVo>> findByTerminalPaginationDto(
          @RequestParam("page") Integer page,
          @RequestParam("size") Integer size,
          @SpringQueryMap TerminalPaginationDto dto);

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/terminal/terminal/findByTerminalCodeSearchDto"})
  Result<Set<String>> findByTerminalCodeSearchDto(@RequestBody TerminalCodeSearchDto dto);

  /**
   * 根据组织、渠道、标签获取匹配的终端基本信息
   *
   * @param dto 参数dto
   * @return 终端基本信息
   */
  @ApiOperation(value = "根据组织、渠道、标签获取匹配的终端基本信息")
  @GetMapping("/v1/terminal/terminal/findByTerminalSearchDto")
  Result<List<TerminalVo>> findByTerminalSearchDto(@SpringQueryMap TerminalSearchDto dto);

  /**
   * 根据TerminalQueryDto获取对应的终端编码集合
   *
   * @param dto
   * @return
   */
  @PostMapping("/v1/terminal/terminal/findByTerminalQueryDto")
  Result<Set<String>> findByTerminalQueryDto(@RequestBody TerminalQueryDto dto);

  /**
   * 根据组织获取组织及下级所有的审核通过且未删除的终端信息
   *
   * @param orgCodes
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findAllowSaleTerminalByOrgCodes")
  Result<Map<String, Set<String>>> findAllowSaleTerminalByOrgCodes(@RequestParam("orgCodes") Set<String> orgCodes);

  /**
   * 根据高德id集合获取对应的终端信息
   *
   * @param amapIds
   * @return 客户信息集合
   */
  @ApiOperation(value = "根据高德id集合获取对应的终端信息")
  @GetMapping("/v1/terminal/terminal/findByAmapIds")
  Result<List<TerminalVo>> findByAmapIds(@RequestParam("amapIds") Set<String> amapIds);

  /**
   * 门店新增
   *
   * @param dto
   * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo>
   * @describe: 简述
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2022.11.4 14:18
   */
  @ApiOperation(value = "门店新增")
  @PostMapping("/v1/terminal/terminal")
  Result<TerminalVo> create(@RequestBody TerminalDto dto);

  /**
   * 门店更新
   *
   * @param dto
   * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo>
   * @describe: 简述
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2022.11.4 14:18
   */
  @ApiOperation(value = "门店更新")
  @PatchMapping("/v1/terminal/terminal")
  Result<TerminalVo> update(@RequestBody TerminalDto dto);

  /**
   * 门店新增|更新
   *
   * @param dtoList
   * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo>
   * @describe: 简述
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2022.11.4 14:18
   */
  @ApiOperation(value = "门店新增|更新")
  @PostMapping("/v1/terminal/terminal/createOrUpdate")
  Result<List<TerminalVo>> createOrUpdate(@RequestBody List<TerminalDto> dtoList);


  /**
   * 根据客户编码列表获取关联的门店及下级门店信息
   *
   * @param codeList 客户编码列表
   * @return Result<Map < String, Map < String, String>>>
   */
  @ApiOperation(value = "根据客户编码列表获取关联的门店及下级门店信息")
  @PostMapping("/v1/terminal/terminal/findTerminalBycusCodes")
  Result<Map<String, Map<String, String>>> findTerminalBycusCodes(@RequestParam("codeList") List<List<String>> codeList);

  /**
   * 根据编码集合获取终端详情
   *
   * @param codes
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findDetailsByTerminalCodesPOST")
  Result<List<TerminalVo>> findDetailsByTerminalCodesPOST(@RequestBody List<String> codes);

  /**
   * 获取全部区域数据
   *
   * @return Result<List < String>>
   */
  @ApiOperation(value = "获取全部区域数据")
  @PostMapping("/v1/terminal/terminal/findTerminalRegion")
  Result<Map<String, String>> findTerminalRegion();

  /**
   * 根据区域编码列表获取区域名称
   *
   * @param codes 区域编码
   * @return Map<String, String>
   */
  @ApiOperation(value = "根据区域编码列表获取区域名称")
  @PostMapping("/v1/terminal/terminal/findTerminalRegionByCodes")
  Result<Map<String, String>> findTerminalRegionByCodes(@RequestBody List<String> codes);

  @ApiOperation("条件查询")
  @PostMapping("/v1/terminal/terminal/findBaseByTerminalCodes")
  Result<List<TerminalVo>> findBaseByTerminalCodes(@RequestBody List<String> terminalCodeList);

  @ApiOperation("条件查询")
  @PostMapping("/v1/terminal/terminal/findListByConditions")
  Result<List<TerminalVo>> findListByConditions(@RequestBody TerminalPaginationDto dto);

  @ApiOperation("查询门店通过区域+零售商+城市")
  @PostMapping("/v1/terminal/terminal/findListByRegionRetailerCityCodes")
  Result<List<TerminalVo>> findListByRegionRetailerCityCodes(@RequestBody TerminalRegionRetailerCityDto dto);

  @ApiOperation("分页条件查询门店基础信息")
  @GetMapping("/v1/terminal/terminal/findBaseByDto")
  Result<Page<TerminalVo>> findBaseByDto(@RequestParam("page") Integer page,
                                         @RequestParam("size") Integer size,
                                         @SpringQueryMap TerminalPaginationDto dto);

  @ApiOperation("根据条件查询终端距离信息")
  @PostMapping("/v1/terminal/terminal/findTerminalDistanceByTerminalQueryDto")
  Result<Page<TerminalVo>> findTerminalDistanceByTerminalQueryDto(@RequestBody TerminalDistanceQueryDto dto);

  @ApiOperation("根据给定客户（经销商）编号、终端门店编号，查询条件，判断是否满足以上的查询条件，返回Boolean")
  @PostMapping("/v1/terminal/terminal/validateCustomerAndTerminal")
  Result<Boolean> validateCustomerAndTerminal(@RequestParam("terminalCode") String terminalCode,
                                              @RequestParam("customerCode") String customerCode,
                                              @RequestBody CustomerTerminalValidateDto dto);

  /**
   * 获取指定客户的门店列表
   *
   * @param dto 查询条件
   * @return 获取指定客户的门店列表
   */
  @ApiOperation("获取指定客户的门店列表")
  @PostMapping("/v1/terminal/terminal/getCustomerTerminalList")
  Result<List<CustomerTerminalVo>> getCustomerTerminalList(@RequestBody List<CustomerTerminalQueryDto> dto);
}
