package com.biz.crm.mdm.business.terminal.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.TerminalClientVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalClientDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalClientVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 客户feign熔断实现
 *
 * @author songjingen
 */
@Component
public class TerminalClientVoServiceFeignImpl implements FallbackFactory<TerminalClientVoServiceFeign> {

  @Override
  public TerminalClientVoServiceFeign create(Throwable throwable) {
    return new TerminalClientVoServiceFeign() {
      @Override
      public Result<Page<TerminalClientVo>> findChildrenPageByTerminalClientDto(@RequestParam("page") Integer page,
                                                                                @RequestParam("size") Integer size,
                                                                                @SpringQueryMap TerminalClientDto dto) {
        throw new UnsupportedOperationException("查询当前用户及其下属所关联的终端信息分页列表熔断");
      }
    };
  }
}
