package com.biz.crm.mdm.business.terminal.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.TerminalVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.*;
import com.biz.crm.mdm.business.terminal.sdk.vo.CustomerTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 终端feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class TerminalVoServiceFeignImpl implements FallbackFactory<TerminalVoServiceFeign> {

  @Override
  public TerminalVoServiceFeign create(Throwable throwable) {
    return new TerminalVoServiceFeign() {
      @Override
      public Result<List<TerminalVo>> findDetailByIdsOrCodes(List<String> ids, List<String> codes) {
        throw new UnsupportedOperationException("根据id或编码集合获取终端详情熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("根据组织编码集合获取终端详情熔断");
      }

      @Override
      public Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
          List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据编码获取终端主信息+组织信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findMainDetailsByTerminalCodesUsePost(List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据编码获取终端主信息+组织信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findTerminalAndContactByTerminalCodes(List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据终端编码集合获取终端主信息+联系人熔断");
      }

      @Override
      public Result<Page<TerminalVo>> findByTerminalPaginationDto(Integer page, Integer size, TerminalPaginationDto dto) {
        throw new UnsupportedOperationException("终端分页信息熔断");
      }

      @Override
      public Result<Set<String>> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        throw new UnsupportedOperationException("根据组织、渠道、标签获取匹配的终端编码信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByTerminalSearchDto(TerminalSearchDto dto) {
        throw new UnsupportedOperationException("根据组织、渠道、标签获取匹配的终端基本信息熔断");
      }

      @Override
      public Result<Set<String>> findByTerminalQueryDto(TerminalQueryDto dto) {
        throw new UnsupportedOperationException("根据TerminalQueryDto获取对应的终端编码集合熔断");
      }

      @Override
      public Result<Map<String, Set<String>>> findAllowSaleTerminalByOrgCodes(
          Set<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织获取组织及下级所有的审核通过且未删除的终端信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByAmapIds(Set<String> amapIds) {
        throw new UnsupportedOperationException("根据高德id集合获取对应的终端信息熔断");
      }

      @Override
      public Result<TerminalVo> create(TerminalDto dto) {
        throw new UnsupportedOperationException("新增终端信息熔断");
      }

      @Override
      public Result<TerminalVo> update(TerminalDto dto) {
        throw new UnsupportedOperationException("更新终端信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> createOrUpdate(List<TerminalDto> dtoList) {
        throw new UnsupportedOperationException("新增或更新终端信息熔断");
      }

      @Override
      public Result<Map<String, Map<String, String>>> findTerminalBycusCodes(List<List<String>> codeList) {
        throw new UnsupportedOperationException("根据客户编码列表获取关联的门店及下级门店信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findDetailsByTerminalCodesPOST(List<String> codes) {
        throw new UnsupportedOperationException("根据编码集合获取终端详情熔断");
      }

        @Override
        public Result<Map<String, String>> findTerminalRegion() {
            throw new UnsupportedOperationException("查询所有区域信息熔断");
        }

        @Override
        public Result<Map<String, String>> findTerminalRegionByCodes(List<String> codes) {
            throw new UnsupportedOperationException("根据区域编码列表获取区域名称熔断");
        }

      @Override
      public Result<List<TerminalVo>> findBaseByTerminalCodes(List<String> terminalCodeList) {
        throw new UnsupportedOperationException("条件查询熔断");
      }

      @Override
      public Result<List<TerminalVo>> findListByConditions(TerminalPaginationDto dto) {
        throw new UnsupportedOperationException("条件查询熔断");
      }

      @Override
      public Result<List<TerminalVo>> findListByRegionRetailerCityCodes(TerminalRegionRetailerCityDto dto) {
        throw new UnsupportedOperationException("查询门店通过区域+零售商+城市熔断");
      }

      @Override
      public Result<Page<TerminalVo>> findBaseByDto(Integer page,Integer size, TerminalPaginationDto dto) {
        throw new UnsupportedOperationException("分页条件查询门店基础信息熔断");
      }

      @Override
      public Result<Page<TerminalVo>> findTerminalDistanceByTerminalQueryDto(TerminalDistanceQueryDto dto) {
        throw new UnsupportedOperationException("分页条件查询门店基础距离信息熔断");
      }

      @Override
      public Result<Boolean> validateCustomerAndTerminal(String terminalCode, String customerCode, CustomerTerminalValidateDto dto) {
        throw new UnsupportedOperationException("校验门店上级客户熔断");
      }

      @Override
      public Result<List<CustomerTerminalVo>> getCustomerTerminalList(List<CustomerTerminalQueryDto> dto) {
        throw new UnsupportedOperationException("获取指定客户的门店列表熔断");
      }
    };
  }
}
