package com.biz.crm.mdm.business.terminal.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.TerminalVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.*;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.CustomerTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 终端sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service("FeignTerminalVoServiceImpl")
public class TerminalVoServiceImpl implements TerminalVoService {

  @Autowired(required = false)
  private TerminalVoServiceFeign terminalVoServiceFeign;

  @Override
  public List<TerminalVo> findDetailsByIdsOrTerminalCodes(
          List<String> ids, List<String> terminalCodes) {
    ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
    terminalCodes = Optional.ofNullable(terminalCodes).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findDetailByIdsOrCodes(ids, terminalCodes).getResult();
  }

  @Override
  public List<TerminalVo> findTerminalAndContactByTerminalCodes(List<String> terminalCodeList) {
    return this.terminalVoServiceFeign
            .findTerminalAndContactByTerminalCodes(terminalCodeList).getResult();
  }

  @Override
  public List<TerminalVo> findDetailsByTerminalCodesPOST(List<String> terminalCodes) {
    return this.terminalVoServiceFeign.findDetailsByTerminalCodesPOST(terminalCodes).getResult();
  }

  @Override
  public Page<TerminalVo> findByTerminalPaginationDto(
          Pageable pageable, TerminalPaginationDto dto) {
    return this.terminalVoServiceFeign
            .findByTerminalPaginationDto(pageable.getPageNumber(), pageable.getPageSize(), dto)
            .getResult();
  }

  @Override
  public List<TerminalVo> findMainDetailsByTerminalCodesUsePost(List<String> terminalCodeList) {
    terminalCodeList = Optional.ofNullable(terminalCodeList).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findMainDetailsByTerminalCodesUsePost(terminalCodeList).getResult();
  }

  @Override
  public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
    return this.terminalVoServiceFeign.findByTerminalCodeSearchDto(dto).getResult();
  }

  @Override
  public TerminalVo create(TerminalDto dto) {
    return this.terminalVoServiceFeign.create(dto).getResult();
  }

  @Override
  public TerminalVo update(TerminalDto dto) {
    return this.terminalVoServiceFeign.update(dto).getResult();
  }

  @Override
  public List<TerminalVo> createOrUpdate(List<TerminalDto> dtoList) {
    if (CollectionUtils.isEmpty(dtoList)) {
      return Collections.emptyList();
    }
    Result<List<TerminalVo>> result = this.terminalVoServiceFeign.createOrUpdate(dtoList);
    Assert.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }

  @Override
  public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
    return this.terminalVoServiceFeign.findByTerminalQueryDto(dto).getResult();
  }

  @Override
  public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
    if (CollectionUtils.isEmpty(terminalCodeList)) {
      return Collections.emptyList();
    }
    terminalCodeList = Optional.ofNullable(terminalCodeList).orElse(Lists.newLinkedList());
    return this.terminalVoServiceFeign.findMainDetailsByTerminalCodes(terminalCodeList).getResult();
  }

  @Override
  public Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return Collections.emptyMap();
    }
    return this.terminalVoServiceFeign.findAllowSaleTerminalByOrgCodes(orgCodes).getResult();
  }

  @Override
  public List<TerminalVo> findByTerminalSearchDto(TerminalSearchDto dto) {
    return this.terminalVoServiceFeign.findByTerminalSearchDto(dto).getResult();
  }

  /**
   * 根据客户编码列表获取关联的门店及下级门店信息
   *
   * @param codeList 客户编码列表
   * @return Map<String, Map < String, String>>
   */
  @Override
  public Map<String, Map<String, String>> findTerminalBycusCodes(List<List<String>> codeList) {
    return this.terminalVoServiceFeign.findTerminalBycusCodes(codeList).getResult();
  }

  /**
   * 获取全部区域数据
   *
   * @return Map<String, String>
   */
  @Override
  public Map<String, String> findTerminalRegion() {
    Result<Map<String, String>> result = this.terminalVoServiceFeign.findTerminalRegion();
    Assert.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }

  /**
   * 根据区域编码列表获取区域名称
   *
   * @param codes 区域编码
   * @return Map<String, String>
   */
  @Override
  public Map<String, String> findTerminalRegionByCodes(List<String> codes) {
    Result<Map<String, String>> result = this.terminalVoServiceFeign.findTerminalRegionByCodes(codes);
    Assert.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }

  @Override
  public List<TerminalVo> findBaseByTerminalCodes(List<String> terminalCodeList) {
    Result<List<TerminalVo>> result = this.terminalVoServiceFeign.findBaseByTerminalCodes(terminalCodeList);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return Lists.newArrayList();
  }

  @Override
  public List<TerminalVo> findListByConditions(TerminalPaginationDto dto) {
    Result<List<TerminalVo>> result = this.terminalVoServiceFeign.findListByConditions(dto);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return Lists.newArrayList();
  }

  @Override
  public List<TerminalVo> findByAmapIds(Set<String> amapIds) {
    if (CollectionUtils.isEmpty(amapIds)) {
      return Collections.emptyList();
    }
    return this.terminalVoServiceFeign.findByAmapIds(amapIds).getResult();
  }

  /**
   * 查询门店通过区域+零售商+城市
   *
   * @param dto 参数
   * @return List<TerminalVo>
   */
  @Override
  public List<TerminalVo> findListByRegionRetailerCityCodes(TerminalRegionRetailerCityDto dto) {
    Result<List<TerminalVo>> result = this.terminalVoServiceFeign.findListByRegionRetailerCityCodes(dto);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return Lists.newArrayList();
  }

  /**
   * 分页条件查询门店基础信息
   *
   * @param pageable 分页参数
   * @param dto      参数dto
   * @return 终端分页信息
   */
  @Override
  public Page<TerminalVo> findBaseByDto(Pageable pageable, TerminalPaginationDto dto) {
    Result<Page<TerminalVo>> result = this.terminalVoServiceFeign.findBaseByDto(pageable.getPageNumber(), pageable.getPageSize(), dto);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return new Page<>();
  }

  @Override
  public Boolean validateCustomerAndTerminal(String terminalCode,
                                             String customerCode,
                                             CustomerTerminalValidateDto dto) {
    Result<Boolean> result = this.terminalVoServiceFeign.validateCustomerAndTerminal(terminalCode, customerCode, dto);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return false;
  }

  @Override
  public Page<TerminalVo> findTerminalDistanceByTerminalQueryDto(TerminalDistanceQueryDto dto) {
    Result<Page<TerminalVo>> result = this.terminalVoServiceFeign.findTerminalDistanceByTerminalQueryDto(dto);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return new Page<>();
  }

  @Override
  public List<CustomerTerminalVo> getCustomerTerminalList(List<CustomerTerminalQueryDto> dto) {
    Result<List<CustomerTerminalVo>> result = this.terminalVoServiceFeign.getCustomerTerminalList(dto);
    if (result.isSuccess()) {
      return result.getResult();
    }
    return new ArrayList<>();
  }
}
