package com.biz.crm.mdm.business.terminal.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.internal.TerminalSupplyVoServiceFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 终端供货关系feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalSupplyVoServiceFeignImpl.class)
public interface TerminalSupplyVoServiceFeign {

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param codes
   * @return
   */
  @GetMapping("/v1/terminal/terminalSupply/findByTerminalCodes")
  Result<List<TerminalSupplyVo>> findByTerminalCodes(@RequestParam("codes") List<String> codes);

  /**
   * 获取终端指定物料的供货经销商编码集合
   *
   * @param terminalCode
   * @param materialCode
   * @returnø
   */
  @GetMapping(value = {"/v1/terminal/terminalSupply/findTerminalSupplyCustomerCodeSet"})
  Result<Set<String>> findTerminalSupplyCustomerCodeSet(
      @RequestParam("terminalCode") String terminalCode,
      @RequestParam("materialCode") String materialCode);

}
