package com.biz.crm.mdm.business.terminal.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.internal.TerminalRelaOrgVoServiceFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 终端组织关系feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalRelaOrgVoServiceFeignImpl.class)
public interface TerminalRelaOrgVoServiceFeign {

  /**
   * 根据企业组织编码获取匹配的终端信息
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminalRelaOrg/findByOrgCodes")
  Result<List<TerminalRelaOrgVo>> findByOrgCodes(
      @RequestParam("orgCodeList") List<String> orgCodeList);
}
