package com.biz.crm.mdm.business.terminal.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.internal.TerminalVoServiceFeignImpl;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 终端feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = TerminalVoServiceFeignImpl.class)
public interface TerminalVoServiceFeign {

  /**
   * 根据id或编码集合获取终端详情
   *
   * @param ids
   * @param codes
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findDetailByIdsOrCodes")
  Result<List<TerminalVo>> findDetailByIdsOrCodes(
      @RequestParam("ids") List<String> ids, @RequestParam("codes") List<String> codes);

  /**
   * 根据企业组织编码获取匹配的终端信息
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findByOrgCodes")
  Result<List<TerminalVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList);

  /**
   * 根据编码获取终端主信息+组织信息
   *
   * @param terminalCodeList
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findMainDetailsByTerminalCodes")
  Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
      @RequestParam("terminalCodeList") List<String> terminalCodeList);

  /**
   * 根据编码获取终端主信息+组织信息
   *
   * @param terminalCodeList
   * @return
   */
  @PostMapping("/v1/terminal/terminal/findMainDetailsByTerminalCodesUsePost")
  Result<List<TerminalVo>> findMainDetailsByTerminalCodesUsePost(
      @RequestBody List<String> terminalCodeList);

  /**
   * 根据终端编码集合获取终端主信息+联系人
   *
   * @param terminalCodeList
   * @return
   */
  @ApiOperation(value = "根据终端编码集合获取终端主信息+联系人")
  @PostMapping("/v1/terminal/terminal/findTerminalAndContactByTerminalCodes")
  Result<List<TerminalVo>> findTerminalAndContactByTerminalCodes(@RequestBody List<String> terminalCodeList);

  /**
   * 分页条件查询
   *
   * @param dto 参数dto
   * @return 终端分页信息
   */
  @ApiOperation(value = "分页条件查询")
  @GetMapping(value = {"/v1/terminal/terminal/findByTerminalPaginationDto"})
  Result<Page<TerminalVo>> findByTerminalPaginationDto(
      @RequestParam("page") Integer page,
      @RequestParam("size") Integer size,
      @SpringQueryMap TerminalPaginationDto dto);

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/terminal/terminal/findByTerminalCodeSearchDto"})
  Result<Set<String>> findByTerminalCodeSearchDto(@RequestBody TerminalCodeSearchDto dto);

  /**
   * 根据组织、渠道、标签获取匹配的终端基本信息
   *
   * @param dto 参数dto
   * @return 终端基本信息
   */
  @ApiOperation(value = "根据组织、渠道、标签获取匹配的终端基本信息")
  @GetMapping("/v1/terminal/terminal/findByTerminalSearchDto")
  Result<List<TerminalVo>> findByTerminalSearchDto(@SpringQueryMap TerminalSearchDto dto);

  /**
   * 根据TerminalQueryDto获取对应的终端编码集合
   *
   * @param dto
   * @return
   */
  @PostMapping("/v1/terminal/terminal/findByTerminalQueryDto")
  Result<Set<String>> findByTerminalQueryDto(@RequestBody TerminalQueryDto dto);

  /**
   * 根据组织获取组织及下级所有的审核通过且未删除的终端信息
   *
   * @param orgCodes
   * @return
   */
  @GetMapping("/v1/terminal/terminal/findAllowSaleTerminalByOrgCodes")
  Result<Map<String, Set<String>>> findAllowSaleTerminalByOrgCodes(@RequestParam("orgCodes") Set<String> orgCodes);

  /**
   * 根据高德id集合获取对应的终端信息
   *
   * @param amapIds
   * @return 客户信息集合
   */
  @ApiOperation(value = "根据高德id集合获取对应的终端信息")
  @GetMapping("/v1/terminal/terminal/findByAmapIds")
  Result<List<TerminalVo>> findByAmapIds(@RequestParam("amapIds") Set<String> amapIds);
}
