package com.biz.crm.mdm.business.terminal.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.feign.feign.TerminalVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.*;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 终端feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class TerminalVoServiceFeignImpl implements FallbackFactory<TerminalVoServiceFeign> {

  @Override
  public TerminalVoServiceFeign create(Throwable throwable) {
    return new TerminalVoServiceFeign() {
      @Override
      public Result<List<TerminalVo>> findDetailByIdsOrCodes(List<String> ids, List<String> codes) {
        throw new UnsupportedOperationException("根据id或编码集合获取终端详情熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("根据组织编码集合获取终端详情熔断");
      }

      @Override
      public Result<List<TerminalVo>> findMainDetailsByTerminalCodes(
          List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据编码获取终端主信息+组织信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findMainDetailsByTerminalCodesUsePost(List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据编码获取终端主信息+组织信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findTerminalAndContactByTerminalCodes(List<String> terminalCodeList) {
        throw new UnsupportedOperationException("根据终端编码集合获取终端主信息+联系人熔断");
      }

      @Override
      public Result<Page<TerminalVo>> findByTerminalPaginationDto(Integer page, Integer size, TerminalPaginationDto dto) {
        throw new UnsupportedOperationException("终端分页信息熔断");
      }

      @Override
      public Result<Set<String>> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        throw new UnsupportedOperationException("根据组织、渠道、标签获取匹配的终端编码信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByTerminalSearchDto(TerminalSearchDto dto) {
        throw new UnsupportedOperationException("根据组织、渠道、标签获取匹配的终端基本信息熔断");
      }

      @Override
      public Result<Set<String>> findByTerminalQueryDto(TerminalQueryDto dto) {
        throw new UnsupportedOperationException("根据TerminalQueryDto获取对应的终端编码集合熔断");
      }

      @Override
      public Result<Map<String, Set<String>>> findAllowSaleTerminalByOrgCodes(
          Set<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织获取组织及下级所有的审核通过且未删除的终端信息熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByAmapIds(Set<String> amapIds) {
        throw new UnsupportedOperationException("根据高德id集合获取对应的终端信息熔断");
      }

      @Override
      public Result<?> modifyShareBenefits(TerminalDto dto) {
        throw new UnsupportedOperationException("根据编码修改是否分利熔断");
      }

      @Override
      public Result<List<TerminalVo>> findByLngAndLat(
          TerminalLugAndLatQueryDto dto) {
        throw new UnsupportedOperationException("根据经度纬度查找范围内的终端熔断");
      }

      @Override
      public Result<List<TerminalVo>> findTerminalList(TerminalNewSearchDto dto) {
        throw new UnsupportedOperationException("根据id集合查询终端信息熔断");
      }
    };
  }
}
