package com.biz.crm.mdm.business.terminal.feign.service.internal;

import com.biz.crm.mdm.business.terminal.feign.feign.TerminalSupplyVoServiceFeign;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 终端供货关系sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class TerminalSupplyVoServiceImpl implements TerminalSupplyVoService {

  @Autowired(required = false) private TerminalSupplyVoServiceFeign terminalSupplyVoServiceFeign;


  @Override
  public List<TerminalSupplyVo> findByTerminalCodes(List<String> terminalCodeList) {
    terminalCodeList = Optional.ofNullable(terminalCodeList).orElse(Lists.newLinkedList());
    return terminalSupplyVoServiceFeign.findByTerminalCodes(terminalCodeList).checkFeignResult();
  }

  @Override
  public List<TerminalSupplyVo> findByCustomerCodes(Set<String> customerCodeSet) {
    customerCodeSet = Optional.ofNullable(customerCodeSet).orElse(new HashSet<>());
    return terminalSupplyVoServiceFeign.findByCustomerCodes(customerCodeSet).checkFeignResult();
  }

  @Override
  public void saveBatch(List<TerminalSupplyDto> list, String terminalCode) {
    throw new UnsupportedOperationException();
  }


  public void deleteByTerminalCodes(List<String> terminalCodes) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Set<String> findTerminalSupplyCustomerCodeSet(String terminalCode, String materialCode) {
    return this.terminalSupplyVoServiceFeign
        .findTerminalSupplyCustomerCodeSet(terminalCode, materialCode)
        .checkFeignResult();
  }
}
