package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalRelaOrgVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/4
 */
@Slf4j
@Api(tags = "终端管理: TerminalRelaOrgVo: 终端管理组织SDK")
@RestController
@RequestMapping(value = {"/v1/terminal/terminalRelaOrg"})
public class TerminalRelaOrgVoController {

  @Autowired(required = false) private TerminalRelaOrgVoService terminalRelaOrgVoService;

  /**
   * 根据企业组织编码获取匹配的终端信息
   *
   * @param orgCodeList
   * @return
   */
  @ApiOperation(value = "根据企业组织编码获取匹配的终端信息")
  @GetMapping("/findByOrgCodes")
  public Result<List<TerminalRelaOrgVo>> findByOrgCodes(
      @RequestParam("orgCodeList") List<String> orgCodeList) {
    try {
      return Result.ok(this.terminalRelaOrgVoService.findByOrgCodes(orgCodeList));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
