package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 供货关系
 *
 * @author sunx
 * @date 2021/11/17
 */
@Slf4j
@Api(tags = "终端管理: TerminalSupplyVo: 供货关系")
@RestController
@RequestMapping(value = {"/v1/terminal/terminalSupply"})
public class TerminalSupplyVoController {

  @Autowired(required = false) private TerminalSupplyVoService terminalSupplyVoService;

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param codes
   * @return
   */
  @ApiOperation(value = "根据终端编码集合获取匹配信息")
  @GetMapping(value = {"/findByTerminalCodes"})
  public Result<List<TerminalSupplyVo>> findByTerminalCodes(
      @RequestParam("codes") List<String> codes) {
    try {
      List<TerminalSupplyVo> list = this.terminalSupplyVoService.findByTerminalCodes(codes);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取终端指定物料的供货经销商编码集合
   *
   * @param terminalCode
   * @param materialCode
   * @returnø
   */
  @ApiOperation(value = "获取终端指定物料的供货经销商编码集合")
  @GetMapping(value = {"/findTerminalSupplyCustomerCodeSet"})
  public Result<Set<String>> findTerminalSupplyCustomerCodeSet(
      @RequestParam("terminalCode") String terminalCode,
      @RequestParam("materialCode") String materialCode) {
    try {
      return Result.ok(
          this.terminalSupplyVoService.findTerminalSupplyCustomerCodeSet(
              terminalCode, materialCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
