package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalTagVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * 终端标签Vo控制层
 *
 * @author sunx
 * @date 2021-11-02 13:48:03
 */
@Slf4j
@Api(tags = "终端管理: TerminalTagVo: 终端标签")
@RestController
@RequestMapping(value = {"/v1/terminalTag/TerminalTagVo"})
public class TerminalTagVoController {

  @Autowired(required = false)
  private TerminalTagVoService terminalTagVoService;

  /**
   * 通过终端编码查询标签列表
   *
   * @param terminalCodes
   * @return
   */
  @ApiOperation(value = "通过终端编码查询标签列表")
  @GetMapping(value = {"/findByTerminalCodes"})
  public Result<List<TerminalTagVo>> findByTerminalCodes(@RequestParam("terminalCodes") Set<String> terminalCodes) {
    try {
      List<TerminalTagVo> list = this.terminalTagVoService.findByTerminalCodes(terminalCodes);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
