package com.biz.crm.mdm.business.terminal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端业务员(TerminalSupply)实体类
 *
 * @author sunx
 * @since 2021-10-18 18:21:24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal_supply")
@Table(
    name = "mdm_terminal_supply",
    indexes = {
      @Index(name = "mdm_terminal_supply_index0", columnList = "tenant_code"),
      @Index(name = "mdm_terminal_supply_index1", columnList = "terminal_code"),
      @Index(name = "mdm_terminal_supply_index3", columnList = "customer_code"),
      @Index(name = "mdm_terminal_supply_index4", columnList = "position_code"),
      @Index(name = "mdm_terminal_supply_index5", columnList = "user_name"),
      @Index(name = "mdm_terminal_supply_index6", columnList = "supply_type"),
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_supply", comment = "终端业务员")
@ApiModel(value = "TerminalSupply", description = "终端业务员")
public class TerminalSupply extends TenantEntity {
  private static final long serialVersionUID = -8611254580674041546L;

  /** 供货关系类型 */
  @ApiModelProperty("供货关系类型")
  @TableField(value = "supply_type")
  @Column(name = "supply_type", length = 64, columnDefinition = "varchar(64) COMMENT '供货关系类型'")
  private String supplyType;

  /** 用户账号 */
  @ApiModelProperty("用户账号")
  @TableField(value = "user_name")
  @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '用户账号'")
  private String userName;

  /** 用户编码 */
  @ApiModelProperty("用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code", length = 64, columnDefinition = "varchar(64) COMMENT '用户编码'")
  private String userCode;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '组织编码'")
  private String orgCode;

  /** 上级客户编码 */
  @ApiModelProperty("上级客户编码")
  @TableField(value = "customer_code")
  @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '上级客户编码'")
  private String customerCode;

  /** 上级客户 */
  @TableField(exist = false)
  @Transient
  private String customerName;

  /** 职位编码 */
  @ApiModelProperty("职位编码")
  @TableField(value = "position_code")
  @Column(name = "position_code", length = 64, columnDefinition = "varchar(64) COMMENT '职位编码'")
  private String positionCode;

  /** 销售公司编码 */
  @ApiModelProperty("销售公司编码")
  @TableField(value = "sale_company")
  @Column(name = "sale_company", length = 128, columnDefinition = "varchar(128) COMMENT '销售公司编码'")
  private String saleCompany;

  /** 渠道 */
  @ApiModelProperty("渠道")
  @TableField(value = "channel")
  @Column(name = "channel", length = 255, columnDefinition = "varchar(255) COMMENT '渠道'")
  private String channel;

  /** 渠道名称 */
  @ApiModelProperty("渠道名称")
  @TableField(value = "channel_name")
  @Column(name = "channel_name", length = 255, columnDefinition = "varchar(255) COMMENT '渠道名称'")
  private String channelName;

  /** 供货明细 */
  @TableField(exist = false)
  @Transient
  private List<TerminalSupplyDetail> detailList;
}
