package com.biz.crm.mdm.business.terminal.local.service;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import java.util.List;

/**
 * 终端扩展信息(TerminalContact)表服务接口
 *
 * @author sunx
 * @since 2021-10-18 17:47:46
 */
public interface TerminalContactService {

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param terminalCodeList
   * @return
   */
  List<TerminalContact> findByTerminalCodes(List<String> terminalCodeList);

  /**
   * 批量保存
   *
   * @param list
   * @param terminalCode
   */
  void saveBatch(List<TerminalContact> list, String terminalCode);

  /**
   * 根据终端编码删除信息
   *
   * @param terminalCodes
   */
  void deleteByTerminalCodes(List<String> terminalCodes);

  /**
   * 新增联系人信息
   *
   * @param contact
   */
  void create(TerminalContact contact);
}
