package com.biz.crm.mdm.business.terminal.local.service;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalBindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalUnbindSupplyDto;
import java.util.List;
import java.util.Set;

/**
 * 终端业务员(TerminalSupply)表服务接口
 *
 * @author sunx
 * @since 2021-10-18 17:49:34
 */
public interface TerminalSupplyService {

  /**
   * 根据终端编码集合获取匹配数据集合
   *
   * @param terminalCodeList
   * @return
   */
  List<TerminalSupply> findByTerminalCodes(List<String> terminalCodeList);

  /**
   * 批量保存
   *
   * @param list
   * @param terminalCode
   * @return
   */
  void saveBatch(List<TerminalSupplyDto> list, String terminalCode);

  /**
   * 绑定供货关系
   *
   * @param dto
   */
  void bind(TerminalBindSupplyDto dto);

  /**
   * 解绑供货关系
   *
   * @param dto
   */
  void unbind(TerminalUnbindSupplyDto dto);

  /**
   * 根据客户信息解除绑定关系
   *
   * @param dto
   */
  void unbindByCustomer(TerminalUnbindSupplyDto dto);

  /**
   * 替换供货关系
   *
   * @param dto
   */
  void rebind(TerminalRebindSupplyDto dto);

  /**
   * 根据客户信息替换供货绑定关系
   *
   * @param dto
   */
  void rebindByCustomer(TerminalRebindSupplyDto dto);

  /**
   * 根据终端编码删除信息
   *
   * @param terminalCodes
   */
  void deleteByTerminalCodes(List<String> terminalCodes);

  /**
   * 根据用户名查询
   *
   * @param userNameList
   */
  List<TerminalSupply> findByUserNames(List<String> userNameList);

  /**
   * 根据客户编码获取关联的供货关系信息
   *
   * @param customerCodeSet
   * @return
   */
  List<TerminalSupply> findByCustomerCodes(Set<String> customerCodeSet);

  /**
   * 根据岗位信息获取供货信息
   *
   * @param positionCodeSet
   * @return
   */
  List<TerminalSupply> findByPositionCodes(Set<String> positionCodeSet);
}
