package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalContactRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 终端扩展信息(TerminalContact)表服务实现类
 *
 * @author sunx
 * @since 2021-10-18 17:47:46
 */
@Service("terminalContactService")
public class TerminalContactServiceImpl implements TerminalContactService {

  @Autowired(required = false) private TerminalContactRepository terminalContactRepository;

  @Override
  public List<TerminalContact> findByTerminalCodes(List<String> terminalCodeList) {
    if (CollectionUtils.isEmpty(terminalCodeList)) {
      return Lists.newLinkedList();
    }
    return terminalContactRepository.findByTerminalCodes(terminalCodeList);
  }

  @Override
  @Transactional
  public void saveBatch(List<TerminalContact> list, String terminalCode) {
    Validate.notBlank(terminalCode, "终端编码信息不能为空");
    terminalContactRepository.deleteByTerminalCodes(Lists.newArrayList(terminalCode));
    if (CollectionUtils.isEmpty(list)) {
      return;
    }

    Optional<TerminalContact> first =
        list.stream()
            .filter(
                a ->
                    StringUtils.isBlank(a.getTerminalCode())
                        || StringUtils.isBlank(a.getContactName())
                        || !terminalCode.equals(a.getTerminalCode()))
            .findFirst();
    Validate.isTrue(!first.isPresent(), "终端编码或联系人不能为空,且必须属于同一终端");

    for (TerminalContact terminalContact : list) {
      terminalContact.setId(null);
      terminalContact.setTenantCode(TenantUtils.getTenantCode());
    }
    terminalContactRepository.saveBatch(list);
  }

  @Override
  @Transactional
  public void deleteByTerminalCodes(List<String> terminalCodes) {
    if (CollectionUtils.isEmpty(terminalCodes)) {
      return;
    }
    this.terminalContactRepository.deleteByTerminalCodes(terminalCodes);
  }

  @Override
  @Transactional
  public void create(TerminalContact contact) {
    Validate.notNull(contact, "联系人信息不能为空");
    this.terminalContactRepository.save(contact);
  }
}
