package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalTagRepository;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalTagVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 终端标签Vo服务实现类
 *
 * @author sunx
 * @date 2021-11-02 13:48:03
 */
@Service
public class TerminalTagVoServiceImpl implements TerminalTagVoService {

  @Autowired(required = false)
  private TerminalTagRepository terminalTagRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<TerminalTagVo> findByTerminalCodes(Set<String> terminalCodeSet) {
    if (CollectionUtils.isEmpty(terminalCodeSet)) {
      return Lists.newLinkedList();
    }
    List<TerminalTag> terminalTags = this.terminalTagRepository.findByTerminalCodes(terminalCodeSet);
    if (CollectionUtils.isEmpty(terminalTags)) {
      return Lists.newLinkedList();
    }
    return (List<TerminalTagVo>) this.nebulaToolkitService.copyCollectionByWhiteList(terminalTags, TerminalTag.class, TerminalTagVo.class, HashSet.class, ArrayList.class);
  }
}
