package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.customer.user.sdk.event.CustomerUserEventListener;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe: 客户用户事件监听器
 * @createTime 2022年01月11日 15:07:00
 */
@Component
public class CustomerUserEventListenerImpl implements CustomerUserEventListener {

  @Autowired(required = false)
  private TerminalSupplyService terminalSupplyService;
  @Autowired(required = false)
  private TerminalService terminalService;

  /**
   * 客户用户删除事件
   *
   * @param list
   */
  @Override
  public void onDelete(List<CustomerUserVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    List<String> userNameList = list.stream().map(CustomerUserVo::getUserName).collect(Collectors.toList());
    List<TerminalSupply> supplyList = this.terminalSupplyService.findByUserNames(userNameList);
    if (CollectionUtils.isEmpty(supplyList)) {
      return;
    }
    List<String> terminalCodes = supplyList.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
    List<Terminal> terminalList = this.terminalService.findByTerminalCodes(terminalCodes);
    Validate.isTrue(CollectionUtils.isEmpty(terminalList),"该客户用户存在关联终端信息，无法删除!");
  }
}
