/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7ba1\u7406: TerminalVo: \u7ec8\u7aef\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/terminal/terminal"})
public class TerminalVoController {
    private static final Logger log = LoggerFactory.getLogger(TerminalVoController.class);
    @Autowired(required=false)
    private TerminalVoService terminalVoService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<TerminalVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            TerminalVo vo = null;
            List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes((List)Lists.newArrayList((Object[])new String[]{id}), null);
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                vo = (TerminalVo)optional.get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aef\u7f16\u7801\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/findDetailByTerminalCode"})
    public Result<TerminalVo> findDetailByTerminalCode(@RequestParam(value="terminalCode") String terminalCode) {
        try {
            TerminalVo vo = null;
            List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, (List)Lists.newArrayList((Object[])new String[]{terminalCode}));
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                vo = (TerminalVo)optional.get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u7ec8\u7aef\u8be6\u60c5")
    @GetMapping(value={"/findDetailByIdsOrCodes"})
    public Result<List<TerminalVo>> findDetailByIdsOrCodes(@RequestParam(value="ids") List<String> ids, @RequestParam(value="codes") List<String> codes) {
        try {
            List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes(ids, codes);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<TerminalVo> create(@RequestBody TerminalDto dto) {
        try {
            TerminalVo current = this.terminalVoService.create(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5e76\u63d0\u4ea4")
    @PostMapping(value={"/handlerCreateAndSubmit"})
    public Result<TerminalVo> handlerCreateAndSubmit(@RequestBody TerminalDto dto) {
        try {
            TerminalVo current = this.terminalVoService.createAndSubmit(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<TerminalVo> update(@RequestBody TerminalDto dto) {
        try {
            TerminalVo current = this.terminalVoService.update(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"updateTurnPatch"})
    public Result<TerminalVo> updateTurnPatch(@RequestBody TerminalDto dto) {
        return this.update(dto);
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec8\u7aef\u4e3b\u4fe1\u606f+\u7ec4\u7ec7\u4fe1\u606f+\u8054\u7cfb\u4eba")
    @GetMapping(value={"/findMainDetailsByTerminalCodes"})
    public Result<List<TerminalVo>> findMainDetailsByTerminalCodes(@RequestParam(value="terminalCodeList") List<String> terminalCodeList) {
        try {
            List list = this.terminalVoService.findMainDetailsByTerminalCodes(terminalCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/findByTerminalPaginationDto"})
    public Result<Page<TerminalVo>> findByTerminalPaginationDto(@PageableDefault(value=50) Pageable pageable, TerminalPaginationDto dto) {
        try {
            dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page result = this.terminalVoService.findByTerminalPaginationDto(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u3001\u6e20\u9053\u3001\u6807\u7b7e\u83b7\u53d6\u5339\u914d\u7684\u7ec8\u7aef\u7f16\u7801")
    @PostMapping(value={"/findByTerminalCodeSearchDto"})
    public Result<Set<String>> findByTerminalCodeSearchDto(@RequestBody TerminalCodeSearchDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findByTerminalCodeSearchDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838")
    @PostMapping(value={"/handlerSubmitAudit"})
    public Result<?> handlerSubmitAudit(@RequestBody TerminalDto dto) {
        try {
            this.terminalVoService.submitAudit(dto);
            return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6838\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eTerminalQueryDto\u83b7\u53d6\u5bf9\u5e94\u7684\u7ec8\u7aef\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/findByTerminalQueryDto"})
    public Result<Set<String>> findByTerminalQueryDto(@RequestBody TerminalQueryDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findByTerminalQueryDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u6240\u6709\u7684\u5ba1\u6838\u901a\u8fc7\u4e14\u672a\u5220\u9664\u7684\u7ec8\u7aef\u4fe1\u606f")
    @GetMapping(value={"/findAllowSaleTerminalByOrgCodes"})
    public Result<Map<String, Set<String>>> findAllowSaleTerminalByOrgCodes(@RequestParam(value="orgCodes") Set<String> orgCodes) {
        try {
            return Result.ok((Object)this.terminalVoService.findAllowSaleTerminalByOrgCodes(orgCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

