/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalContactRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalContactService")
public class TerminalContactServiceImpl
implements TerminalContactService {
    @Autowired(required=false)
    private TerminalContactRepository terminalContactRepository;

    @Override
    public List<TerminalContact> findByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        return this.terminalContactRepository.findByTerminalCodes(terminalCodeList);
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalContact> list, String terminalCode) {
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalContactRepository.deleteByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<TerminalContact> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getTerminalCode()) || StringUtils.isBlank((CharSequence)a.getContactName()) || !terminalCode.equals(a.getTerminalCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u6216\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u7ec8\u7aef", (Object[])new Object[0]);
        for (TerminalContact terminalContact : list) {
            terminalContact.setId(null);
            terminalContact.setTenantCode(TenantUtils.getTenantCode());
        }
        this.terminalContactRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void deleteByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        this.terminalContactRepository.deleteByTerminalCodes(terminalCodes);
    }

    @Override
    @Transactional
    public void create(TerminalContact contact) {
        Validate.notNull((Object)((Object)contact), (String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalContactRepository.save((Object)contact);
    }
}

