/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaCustomerOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRelaOrgRepository;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalContactDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelaCustomerOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelaOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaCustomerOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TerminalVoServiceImpl
implements TerminalVoService {
    @Autowired(required=false)
    private TerminalService terminalService;
    @Autowired(required=false)
    private TerminalRelaOrgService terminalRelaOrgService;
    @Autowired(required=false)
    private TerminalRelaCustomerOrgService terminalRelaCustomerOrgService;
    @Autowired(required=false)
    private TerminalContactService terminalContactService;
    @Autowired(required=false)
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerOrgVoSdkService customerOrgVoSdkService;
    @Autowired(required=false)
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private TerminalRelaOrgRepository terminalRelaOrgRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public List<TerminalVo> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        List<Object> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids) && org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodes)) {
            return re;
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(ids, terminalCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return re;
        }
        re = this.convertEntityToVo(terminalList);
        return re;
    }

    @Transactional
    public TerminalVo create(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getTerminalCode())) {
            dto.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(dto.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(dto.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        terminal.setProcessStatus(ActApproveStatusEnum.CREATE.getCode());
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(dto);
        this.terminalService.create(terminal);
        return this.buildByDtoAndTerminal(dto, terminal);
    }

    @Transactional
    public TerminalVo createAndSubmit(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getTerminalCode())) {
            dto.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(dto.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(dto.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(dto);
        this.terminalService.create(terminal);
        TerminalVo re = this.buildByDtoAndTerminal(dto, terminal);
        dto.setId(terminal.getId());
        terminal.setProcessNumber(this.commitProcess(dto));
        terminal.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.terminalRepository.updateById((Object)terminal);
        return re;
    }

    @Transactional
    public TerminalVo update(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(dto);
        this.terminalService.update(terminal);
        return this.buildByDtoAndTerminal(dto, terminal);
    }

    public List<TerminalVo> findSelectByKeyword(String keyword) {
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        TerminalPaginationDto dto = new TerminalPaginationDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setKeyword(keyword);
        Page<Terminal> page = this.terminalService.findByConditions((Pageable)pageable, dto);
        if (Objects.isNull(page) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (Terminal item : page.getRecords()) {
            TerminalVo cur = new TerminalVo();
            cur.setTerminalCode(item.getTerminalCode());
            cur.setTerminalName(item.getTerminalName());
            list.add(cur);
        }
        return list;
    }

    public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newLinkedList();
        }
        List<TerminalRelaOrg> terminalRelaOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodeList);
        Map map = terminalRelaOrgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()})).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toList())));
        Set orgCodeSet = terminalRelaOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
        Map<Object, Object> mapOrg = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgVoList)) {
            mapOrg = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        Map<Object, Object> terminalContactVoMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(terminalContactList)) {
            List terminalContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        }
        List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgs = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodeList);
        Map<Object, Object> terminalRelaCustomerOrgVoMap = new HashMap();
        Map<Object, Object> customerOrgVoMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(terminalRelaCustomerOrgs)) {
            List terminalRelaCustomerOrgVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaCustomerOrgs, TerminalRelaCustomerOrg.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalRelaCustomerOrgVoMap = terminalRelaCustomerOrgVos.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrgVo::getTerminalCode));
            List customerOrgVos = this.customerOrgVoSdkService.findListByCodes(terminalRelaCustomerOrgVos.stream().map(TerminalRelaCustomerOrgVo::getOrgCode).collect(Collectors.toList()));
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerOrgVos)) {
                customerOrgVoMap = customerOrgVos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName));
            }
        }
        List re = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo item : re) {
            List terminalRelaCustomerOrgVos;
            List terminalContactVos;
            List curOrgCodeList = map.get(item.getTerminalCode());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(curOrgCodeList)) {
                LinkedList curList = Lists.newLinkedList();
                LinkedList orgNameList = Lists.newLinkedList();
                for (String orgCode : curOrgCodeList) {
                    TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
                    cur.setTerminalCode(item.getTerminalCode());
                    cur.setOrgCode(orgCode);
                    cur.setOrgName((String)mapOrg.get(orgCode));
                    curList.add(cur);
                    orgNameList.add(cur.getOrgName());
                }
                item.setOrgList((List)curList);
                item.setOrgNameStr(StringUtils.join((Iterable)orgNameList, (String)","));
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(terminalContactVos = (List)terminalContactVoMap.get(item.getTerminalCode())))) {
                item.setContacts(terminalContactVos);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(terminalRelaCustomerOrgVos = (List)terminalRelaCustomerOrgVoMap.get(item.getTerminalCode())))) continue;
            for (TerminalRelaCustomerOrgVo terminalRelaCustomerOrgVo : terminalRelaCustomerOrgVos) {
                terminalRelaCustomerOrgVo.setOrgName((String)customerOrgVoMap.get(terminalRelaCustomerOrgVo.getOrgCode()));
            }
            item.setCustomerOrgList(terminalRelaCustomerOrgVos);
        }
        return re;
    }

    public Page<TerminalVo> findByTerminalPaginationDto(Pageable pageable, TerminalPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Terminal> entityPage = this.terminalRepository.findByConditions((Page<Terminal>)page, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords(this.convertEntityToVo(entityPage.getRecords()));
        return pageResult;
    }

    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TerminalCodeSearchDto());
        return this.terminalService.findByTerminalCodeSearchDto(dto);
    }

    public List<TerminalVo> findByAmapIds(Set<String> amapIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(amapIds)) {
            return Lists.newArrayList();
        }
        List<Terminal> list = this.terminalRepository.findByAmapIds(amapIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void submitAudit(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessKey(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Terminal terminal = this.terminalRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet((Object[])new String[]{ActApproveStatusEnum.CREATE.getCode(), ActApproveStatusEnum.REJECTED.getCode(), ActApproveStatusEnum.INTERRUPT.getCode()});
        Validate.isTrue((boolean)set.contains(terminal.getProcessStatus()), (String)"\u7ec8\u7aef\u72b6\u6001\u4e0d\u80fd\u6267\u884c\u63d0\u4ea4\u5ba1\u6838", (Object[])new Object[0]);
        dto.setTerminalCode(terminal.getTerminalCode());
        terminal.setProcessNumber(this.commitProcess(dto));
        terminal.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        terminal.setProcessRemark(dto.getProcessRemark());
        terminal.setProcessKey(dto.getProcessKey());
        this.terminalRepository.updateById((Object)terminal);
    }

    public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getTerminalCode(), dto.getTerminalName(), dto.getChannel(), dto.getOrgName(), dto.getDelFlag(), dto.getProcessStatus()})) {
            return Sets.newHashSet();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            OrgQueryDto queryDto = new OrgQueryDto();
            queryDto.setOrgName(dto.getOrgName());
            Set orgCodeSet = this.orgVoService.findByOrgQueryDto(queryDto);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgCodeSet)) {
                return Sets.newHashSet();
            }
            dto.setOrgCodeSet(orgCodeSet);
        }
        return this.terminalRepository.findByTerminalQueryDto(dto);
    }

    public Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Maps.newHashMap();
        }
        RelateOrgCodeQueryDto queryDto = new RelateOrgCodeQueryDto();
        queryDto.setOrgCodeSet(orgCodes);
        queryDto.setSearchType(Integer.valueOf(-1));
        Map orgRuleMap = this.orgVoService.findByRelateOrgCodeQueryDto(queryDto);
        if (CollectionUtils.isEmpty((Map)orgRuleMap)) {
            return Maps.newHashMap();
        }
        List<TerminalRelaOrg> list = this.terminalRelaOrgRepository.findAllowSaleTerminalByOrgCodes(orgRuleMap.keySet());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()}) && orgRuleMap.keySet().contains(a.getOrgCode())).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toSet())));
        HashMap re = Maps.newHashMap();
        for (Map.Entry item : map.entrySet()) {
            HashSet rule = Sets.newHashSet();
            for (String orgCode : item.getValue()) {
                String s = (String)orgRuleMap.get(orgCode);
                if (StringUtils.isBlank((CharSequence)s)) continue;
                rule.add(s);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rule)) continue;
            re.put(item.getKey(), rule);
        }
        return re;
    }

    private void bindExtInfo(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List orgList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrgList())) {
            for (Object item : dto.getOrgList()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
            orgList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getOrgList(), TerminalRelaOrgDto.class, TerminalRelaOrg.class, HashSet.class, ArrayList.class, new String[0]);
            orgList.forEach(a -> a.setTerminalCode(dto.getTerminalCode()));
        }
        this.terminalRelaOrgService.saveBatch(orgList, dto.getTerminalCode());
        List customerOrgList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerOrgList())) {
            for (TerminalRelaCustomerOrgDto item : dto.getCustomerOrgList()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
            customerOrgList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerOrgList(), TerminalRelaCustomerOrgDto.class, TerminalRelaCustomerOrg.class, HashSet.class, ArrayList.class, new String[0]);
            customerOrgList.forEach(a -> a.setTerminalCode(dto.getTerminalCode()));
        }
        this.terminalRelaCustomerOrgService.saveBatch(customerOrgList, dto.getTerminalCode());
        List contactList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getContacts())) {
            for (TerminalContactDto item : dto.getContacts()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
            contactList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getContacts(), TerminalContactDto.class, TerminalContact.class, HashSet.class, ArrayList.class, new String[0]);
            contactList.forEach(a -> a.setTerminalCode(dto.getTerminalCode()));
        }
        this.terminalContactService.saveBatch(contactList, dto.getTerminalCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getSupplys())) {
            for (TerminalContactDto item : dto.getSupplys()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
        }
        this.terminalSupplyVoService.saveBatch(dto.getSupplys(), dto.getTerminalCode());
    }

    private TerminalVo buildByDtoAndTerminal(TerminalDto dto, Terminal terminal) {
        TerminalVo vo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrgList())) {
            vo.setOrgList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getOrgList(), TerminalRelaOrgDto.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerOrgList())) {
            vo.setCustomerOrgList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerOrgList(), TerminalRelaCustomerOrgDto.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getContacts())) {
            vo.setContacts((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getContacts(), TerminalContactDto.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getSupplys())) {
            vo.setSupplys((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getSupplys(), TerminalSupplyDto.class, TerminalSupplyVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }

    private List<TerminalVo> buildTerminalVoList(List<Terminal> terminalList, List<TerminalRelaOrg> terminalRelaOrgList, List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgList, List<TerminalContact> terminalContactList, List<TerminalSupplyVo> terminalSupplyVoList) {
        List list;
        List<TerminalVo> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<Object, Object> mapOrg = Maps.newHashMap();
        Map<Object, Object> mapCustomerOrg = Maps.newHashMap();
        Map<Object, Object> mapContact = Maps.newHashMap();
        Map<Object, Object> mapSupply = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaOrgList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaOrgList, TerminalRelaOrg.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapOrg = list.stream().collect(Collectors.groupingBy(TerminalRelaOrgVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaCustomerOrgList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaCustomerOrgList, TerminalRelaCustomerOrg.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapCustomerOrg = list.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrgVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalContactList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapContact = list.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalSupplyVoList)) {
            mapSupply = terminalSupplyVoList.stream().collect(Collectors.groupingBy(TerminalSupplyVo::getTerminalCode));
        }
        for (TerminalVo vo : re) {
            vo.setOrgList((List)mapOrg.get(vo.getTerminalCode()));
            vo.setCustomerOrgList((List)mapCustomerOrg.get(vo.getTerminalCode()));
            vo.setContacts((List)mapContact.get(vo.getTerminalCode()));
            vo.setSupplys((List)mapSupply.get(vo.getTerminalCode()));
        }
        return re;
    }

    private void validateContacts(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List contacts = dto.getContacts();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)contacts)) {
            return;
        }
        for (TerminalContactDto contact : contacts) {
            if (!StringUtils.isNotBlank((CharSequence)contact.getContactName()) && !StringUtils.isNotBlank((CharSequence)contact.getContactPhone()) && Objects.isNull(contact.getContactMain())) continue;
            Validate.notBlank((CharSequence)contact.getContactPhone(), (String)"\u7f3a\u5931\u8054\u7cfb\u7535\u8bdd", (Object[])new Object[0]);
            Validate.notNull((Object)contact.getContactMain(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u662f\u4e3b\u8054\u7cfb\u4eba", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contact.getContactName(), (String)"\u7f3a\u5931\u59d3\u540d", (Object[])new Object[0]);
        }
        List contanctsByMain = contacts.stream().filter(o -> Boolean.TRUE.equals(o.getContactMain())).collect(Collectors.toList());
        Validate.isTrue((contanctsByMain.size() == 1 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u4e3b\u8054\u7cfb\u4eba", (Object[])new Object[0]);
    }

    private List<TerminalVo> convertEntityToVo(List<Terminal> terminalList) {
        Set customerOrgCodeSet;
        List<Object> re = Lists.newArrayList();
        List<String> terminalCodeList = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return re;
        }
        List<TerminalRelaOrg> terminalRelaOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodeList);
        List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgList = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodeList);
        Set orgCodeSet = terminalRelaOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgCodeSet)) {
            List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
            orgVoList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgVoList) ? Lists.newLinkedList() : orgVoList;
            Map<String, String> map = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
            terminalRelaOrgList.forEach(a -> a.setOrgName((String)map.get(a.getOrgCode())));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerOrgCodeSet = terminalRelaCustomerOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaCustomerOrg::getOrgCode).collect(Collectors.toSet()))) {
            List customerOrgVoList = this.customerOrgVoSdkService.findListByCodes((List)Lists.newArrayList(customerOrgCodeSet));
            customerOrgVoList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerOrgVoList) ? Lists.newLinkedList() : customerOrgVoList;
            Map<String, String> map = customerOrgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName, (a, b) -> a));
            terminalRelaCustomerOrgList.forEach(a -> a.setOrgName((String)map.get(a.getOrgCode())));
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        List terminalSupplyVoList = this.terminalSupplyVoService.findByTerminalCodes(terminalCodeList);
        re = this.buildTerminalVoList(terminalList, terminalRelaOrgList, terminalRelaCustomerOrgList, terminalContactList, terminalSupplyVoList);
        return re;
    }

    private String commitProcess(TerminalDto dto) {
        StartProcessDto activitiBusinessVo = new StartProcessDto();
        activitiBusinessVo.setProcessKey(dto.getProcessKey());
        activitiBusinessVo.setBusinessId(dto.getId());
        activitiBusinessVo.setBusinessNo(dto.getTerminalCode());
        activitiBusinessVo.setRemark(dto.getProcessRemark());
        activitiBusinessVo.setAttachmentVos(dto.getAttachmentVos());
        activitiBusinessVo.setMenuCode(dto.getCompetenceCode());
        activitiBusinessVo.setFormType("terminal_create");
        activitiBusinessVo.setProcessTitle(dto.getProcessTitle());
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)activitiBusinessVo, ProcessListener.class, (SerializableBiConsumer)sf);
        if (StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId())) {
            return response.getProcessInstanceId();
        }
        throw new RuntimeException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01");
    }
}

