/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="terminalPositionEventListenerImpl")
public class PositionEventListenerImpl
implements PositionEventListener {
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;
    @Autowired(required=false)
    private TerminalService terminalService;

    public void onCreate(PositionEventVo vo) {
    }

    public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {
    }

    public void onDisable(List<PositionEventVo> voList) {
    }

    public void onEnable(List<PositionEventVo> voList) {
    }

    public void onDelete(List<PositionEventVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        Set<String> positionCodeSet = voList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPositionCode())).map(PositionEventVo::getPositionCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(positionCodeSet)) {
            return;
        }
        List<TerminalSupply> supplyList = this.terminalSupplyService.findByPositionCodes(positionCodeSet);
        if (CollectionUtils.isEmpty(supplyList)) {
            return;
        }
        List<String> terminalCodes = supplyList.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
        List<Terminal> terminalList = this.terminalService.findByTerminalCodes(terminalCodes);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(terminalList), (String)"\u8be5\u5ba2\u6237\u4e0e\u7ec8\u7aef\u5b58\u5728\u4f9b\u8d27\u5173\u7cfb\u4fe1\u606f\uff0c\u65e0\u6cd5\u5220\u9664!", (Object[])new Object[0]);
    }

    public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
        return null;
    }
}

