/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCusSelectDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionSelectDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSellingPartyDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalEmployeeVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSellingPartyVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgDimChlDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7ba1\u7406: Terminal: \u7ec8\u7aef\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/terminal/terminal"})
public class TerminalController {
    private static final Logger log = LoggerFactory.getLogger(TerminalController.class);
    @Autowired(required=false)
    private TerminalService terminalService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Terminal>> findByConditions(@PageableDefault(value=50) Pageable pageable, TerminalPaginationDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new TerminalPaginationDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            if (StringUtils.isNotBlank((String)paginationDto.getSalesInstitutionCode())) {
                String str = paginationDto.getSalesInstitutionCode();
                paginationDto.setSalesInstitutionCode(str.substring(str.length() - 4));
            }
            Page<Terminal> result = this.terminalService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findTerminalByConditions"})
    public Result<Page<Terminal>> findTerminalByConditions(@PageableDefault(value=50) Pageable pageable, TerminalPaginationDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new TerminalPaginationDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page<Terminal> result = this.terminalService.findTerminalByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u7ec8\u7aef\u8be6\u60c5")
    @PostMapping(value={"/findOrgListByCodeList"})
    public Result<List<SalesOrgVo>> findOrgListByCodeList(@RequestBody List<String> codeList) {
        try {
            List<SalesOrgVo> list = this.terminalService.findOrgListByCodeList(codeList);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u540d\u5e97\u5458\u5de5\u660e\u7ec6")
    @GetMapping(value={"findByConditionsForEmployee"})
    public Result<Page<TerminalEmployeeVo>> findByConditionsForEmployee(@PageableDefault(value=50) Pageable pageable, TerminalPaginationDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new TerminalPaginationDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page<TerminalEmployeeVo> result = this.terminalService.findByConditionsForEmployee(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.terminalService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.terminalService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.terminalService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458\u8d26\u53f7\u83b7\u53d6\u672c\u6708\u7684\u5df2\u5b8c\u6210\u62dc\u8bbf\u6570")
    @GetMapping(value={"findCountByCreateAccountAndFromTypeAndDateType"})
    public Result<?> findCountByCreateAccountAndDateTypeAndFromType(@ApiParam(name="createAccount", value="\u4eba\u5458\u8d26\u53f7") @RequestParam(value="createAccount", required=false) String createAccount, @ApiParam(name="fromType", value="\u4e1a\u52a1\u6765\u6e90\u7cfb\u7edf") @RequestParam(value="fromType") String fromType, @ApiParam(name="dateType", value="\u65e5\u671f\u7c7b\u578b\uff1amonth,week,day") @RequestParam(value="dateType") String dateType) {
        try {
            Map<String, Integer> map = this.terminalService.findCountByCreateAccountAndDateTypeAndFromType(createAccount, dateType, fromType);
            return Result.ok(map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u95e8\u5e97\u4e0b\u62c9")
    @PostMapping(value={"findCusStoreFormSelectList"})
    public Result<List<CommonSelectVo>> findCusStoreFormSelectList(@ApiParam(value="\u5ba2\u6237\u4e0e\u95e8\u5e97\u4e0b\u62c9Dto") @RequestBody TerminalCusSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.terminalService.findCusStoreFormSelectList(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u95e8\u5e97\u4e0b\u62c9")
    @PostMapping(value={"findStoreFormSelectList"})
    public Result<List<CommonSelectVo>> findStoreFormSelectList(@ApiParam(value="\u95e8\u5e97\u4e0b\u62c9Dto") @RequestBody TerminalCusSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.terminalService.findStoreFormSelectList(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6 MDG \u5782\u76f4\u95e8\u5e97\u6570\u636e")
    @GetMapping(value={"/pullDimChlList"})
    public Result<?> pullDimChlList(@ApiParam(name="dto", value="\u5782\u76f4\u95e8\u5e97\u6570\u636e") MasterDataMdgDimChlDto dto) {
        try {
            this.terminalService.pullDimChlList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6 MDG \u5782\u76f4\u95e8\u5e97\u6570\u636e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u533a\u57df\u641c\u7d22\u4e0b\u62c9")
    @PostMapping(value={"findRegionFormSelectList"})
    public Result<List<CommonSelectVo>> findRegionFormSelectList(@ApiParam(value="\u533a\u57df\u4e0b\u62c9Dto") @RequestBody TerminalRegionSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.terminalService.findRegionFormSelectList(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u533a\u57df\u641c\u7d22\u4e0b\u62c9(get\u8bf7\u6c42\uff0c\u6570\u636e\u6743\u9650\u67e5\u6570\u636e\u4f7f\u7528)")
    @GetMapping(value={"findRegionFormSelectListGet"})
    public Result<List<CommonSelectVo>> findRegionFormSelectListGet(@ApiParam(value="\u533a\u57df\u4e0b\u62c9Dto") TerminalRegionSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.terminalService.findRegionFormSelectList(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u552e\u8fbe\u65b9\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findSellingPartyByConditions"})
    public Result<Page<TerminalSellingPartyVo>> findSellingPartyByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="costCenterDto", value="\u552e\u8fbe\u65b9dto") TerminalSellingPartyDto partyDto) {
        try {
            Page<TerminalSellingPartyVo> page = this.terminalService.findSellingPartyByConditions(pageable, partyDto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

