/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.dto.CustomerTerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.CustomerTerminalValidateDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDistanceQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionRetailerCityDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.CustomerTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7ba1\u7406: TerminalVo: \u7ec8\u7aef\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/terminal/terminal"})
public class TerminalVoController {
    private static final Logger log = LoggerFactory.getLogger(TerminalVoController.class);
    @Autowired(required=false)
    private TerminalVoService terminalVoService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<TerminalVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            TerminalVo vo = null;
            List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes((List)Lists.newArrayList((Object[])new String[]{id}), null);
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                vo = (TerminalVo)optional.get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aef\u7f16\u7801\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/findDetailByTerminalCode"})
    public Result<TerminalVo> findDetailByTerminalCode(@RequestParam(value="terminalCode") String terminalCode) {
        try {
            TerminalVo vo = null;
            List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, (List)Lists.newArrayList((Object[])new String[]{terminalCode}));
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                vo = (TerminalVo)optional.get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u7ec8\u7aef\u8be6\u60c5")
    @GetMapping(value={"/findDetailByIdsOrCodes"})
    public Result<List<TerminalVo>> findDetailByIdsOrCodes(@RequestParam(value="ids") List<String> ids, @RequestParam(value="codes") List<String> codes) {
        try {
            List list = this.terminalVoService.findDetailsByIdsOrTerminalCodes(ids, codes);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u7ec8\u7aef\u8be6\u60c5")
    @PostMapping(value={"/findDetailByIdsOrCodes"})
    public Result<List<TerminalVo>> findDetailByIdsOrCodes(@RequestBody List<String> codes) {
        try {
            List list = this.terminalVoService.findDetailsByTerminalCodesPOST(codes);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<TerminalVo> create(@RequestBody TerminalDto dto) {
        try {
            TerminalVo current = this.terminalVoService.create(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"createOrUpdate"})
    public Result<List<TerminalVo>> createOrUpdate(@RequestBody List<TerminalDto> dtoList) {
        try {
            List result = this.terminalVoService.createOrUpdate(dtoList);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5e76\u63d0\u4ea4")
    @PostMapping(value={"/handlerCreateAndSubmit"})
    public Result<TerminalVo> handlerCreateAndSubmit(@RequestBody TerminalDto dto) {
        try {
            TerminalVo current = this.terminalVoService.createAndSubmit(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<TerminalVo> update(@RequestBody TerminalDto dto) {
        try {
            TerminalVo current = this.terminalVoService.update(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"updateTurnPatch"})
    public Result<TerminalVo> updateTurnPatch(@RequestBody TerminalDto dto) {
        return this.update(dto);
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec8\u7aef\u4e3b\u4fe1\u606f+\u7ec4\u7ec7\u4fe1\u606f+\u8054\u7cfb\u4eba")
    @GetMapping(value={"/findMainDetailsByTerminalCodes"})
    public Result<List<TerminalVo>> findMainDetailsByTerminalCodes(@RequestParam(value="terminalCodeList") List<String> terminalCodeList) {
        try {
            List list = this.terminalVoService.findMainDetailsByTerminalCodes(terminalCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec8\u7aef\u4e3b\u4fe1\u606f+\u7ec4\u7ec7\u4fe1\u606f+\u8054\u7cfb\u4eba")
    @PostMapping(value={"/findMainDetailsByTerminalCodesUsePost"})
    public Result<List<TerminalVo>> findMainDetailsByTerminalCodesUsePost(@RequestBody List<String> terminalCodeList) {
        try {
            List list = this.terminalVoService.findMainDetailsByTerminalCodes(terminalCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u7ec8\u7aef\u4e3b\u4fe1\u606f+\u8054\u7cfb\u4eba")
    @PostMapping(value={"/findTerminalAndContactByTerminalCodes"})
    public Result<List<TerminalVo>> findTerminalAndContactByTerminalCodes(@RequestBody List<String> terminalCodeList) {
        try {
            List list = this.terminalVoService.findTerminalAndContactByTerminalCodes(terminalCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/findByTerminalPaginationDto"})
    public Result<Page<TerminalVo>> findByTerminalPaginationDto(@PageableDefault(value=50) Pageable pageable, TerminalPaginationDto dto) {
        try {
            dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page result = this.terminalVoService.findByTerminalPaginationDto(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u3001\u6e20\u9053\u3001\u6807\u7b7e\u83b7\u53d6\u5339\u914d\u7684\u7ec8\u7aef\u7f16\u7801")
    @PostMapping(value={"/findByTerminalCodeSearchDto"})
    public Result<Set<String>> findByTerminalCodeSearchDto(@RequestBody TerminalCodeSearchDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findByTerminalCodeSearchDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u3001\u6e20\u9053\u3001\u6807\u7b7e\u83b7\u53d6\u5339\u914d\u7684\u7ec8\u7aef\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/findByTerminalSearchDto"})
    public Result<List<TerminalVo>> findByTerminalSearchDto(@ApiParam(name="TerminalSearchDto", value="\u67e5\u8be2Dto") TerminalSearchDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findByTerminalSearchDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838")
    @PostMapping(value={"/handlerSubmitAudit"})
    public Result<?> handlerSubmitAudit(@RequestBody TerminalDto dto) {
        try {
            this.terminalVoService.submitAudit(dto);
            return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6838\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eTerminalQueryDto\u83b7\u53d6\u5bf9\u5e94\u7684\u7ec8\u7aef\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/findByTerminalQueryDto"})
    public Result<Set<String>> findByTerminalQueryDto(@RequestBody TerminalQueryDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findByTerminalQueryDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u6240\u6709\u7684\u5ba1\u6838\u901a\u8fc7\u4e14\u672a\u5220\u9664\u7684\u7ec8\u7aef\u4fe1\u606f")
    @GetMapping(value={"/findAllowSaleTerminalByOrgCodes"})
    public Result<Map<String, Set<String>>> findAllowSaleTerminalByOrgCodes(@RequestParam(value="orgCodes") Set<String> orgCodes) {
        try {
            return Result.ok((Object)this.terminalVoService.findAllowSaleTerminalByOrgCodes(orgCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9ad8\u5fb7id\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u7ec8\u7aef\u4fe1\u606f")
    @GetMapping(value={"/findByAmapIds"})
    public Result<List<TerminalVo>> findByAmapIds(@RequestParam(value="amapIds") Set<String> amapIds) {
        try {
            return Result.ok((Object)this.terminalVoService.findByAmapIds(amapIds));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u5217\u8868\u83b7\u53d6\u5173\u8054\u7684\u95e8\u5e97\u53ca\u4e0b\u7ea7\u95e8\u5e97\u4fe1\u606f")
    @PostMapping(value={"/findTerminalBycusCodes"})
    public Result<Map<String, Map<String, String>>> findTerminalBycusCodes(@RequestParam(value="codeList") List<List<String>> codeList) {
        try {
            return Result.ok((Object)this.terminalVoService.findTerminalBycusCodes(codeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u533a\u57df\u6570\u636e")
    @PostMapping(value={"/findTerminalRegion"})
    public Result<Map<String, String>> findTerminalRegion() {
        try {
            Map map = this.terminalVoService.findTerminalRegion();
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u533a\u57df\u7f16\u7801\u5217\u8868\u83b7\u53d6\u533a\u57df\u540d\u79f0")
    @PostMapping(value={"/findTerminalRegionByCodes"})
    public Result<Map<String, String>> findTerminalRegionByCodes(@RequestBody List<String> codes) {
        try {
            Map map = this.terminalVoService.findTerminalRegionByCodes(codes);
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u57fa\u672c\u4fe1\u606f")
    @PostMapping(value={"/findBaseByTerminalCodes"})
    public Result<List<TerminalVo>> findBaseByTerminalCodes(@RequestBody List<String> terminalCodeList) {
        try {
            return Result.ok((Object)this.terminalVoService.findBaseByTerminalCodes(terminalCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2")
    @PostMapping(value={"findListByConditions"})
    public Result<List<TerminalVo>> findListByConditions(@RequestBody TerminalPaginationDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findListByConditions(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u95e8\u5e97\u901a\u8fc7\u533a\u57df+\u96f6\u552e\u5546+\u57ce\u5e02")
    @PostMapping(value={"findListByRegionRetailerCityCodes"})
    public Result<List<TerminalVo>> findListByRegionRetailerCityCodes(@RequestBody TerminalRegionRetailerCityDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findListByRegionRetailerCityCodes(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u95e8\u5e97\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"findBaseByDto"})
    public Result<Page<TerminalVo>> findBaseByDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="TerminalPaginationDto", value="\u5206\u9875Dto") TerminalPaginationDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findBaseByDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7ec8\u7aef\u8ddd\u79bb\u4fe1\u606f")
    @PostMapping(value={"findTerminalDistanceByTerminalQueryDto"})
    public Result<Page<TerminalVo>> findTerminalDistanceByTerminalQueryDto(@RequestBody TerminalDistanceQueryDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.findTerminalDistanceByTerminalQueryDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ed9\u5b9a\u5ba2\u6237\uff08\u7ecf\u9500\u5546\uff09\u7f16\u53f7\u3001\u7ec8\u7aef\u95e8\u5e97\u7f16\u53f7\uff0c\u67e5\u8be2\u6761\u4ef6\uff0c\u5224\u65ad\u662f\u5426\u6ee1\u8db3\u4ee5\u4e0a\u7684\u67e5\u8be2\u6761\u4ef6\uff0c\u8fd4\u56deBoolean")
    @PostMapping(value={"/validateCustomerAndTerminal"})
    public Result<Boolean> validateCustomerAndTerminal(@RequestParam(value="terminalCode") String terminalCode, @RequestParam(value="customerCode") String customerCode, @RequestBody CustomerTerminalValidateDto dto) {
        try {
            return Result.ok((Object)this.terminalVoService.validateCustomerAndTerminal(terminalCode, customerCode, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u5ba2\u6237\u7684\u95e8\u5e97\u5217\u8868")
    @PostMapping(value={"/getCustomerTerminalList"})
    public Result<List<CustomerTerminalVo>> getCustomerTerminalList(@RequestBody List<CustomerTerminalQueryDto> dto) {
        try {
            List list = this.terminalVoService.getCustomerTerminalList(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

