/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.helper;

import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class TerminalHelper {
    private static final Logger log = LoggerFactory.getLogger(TerminalHelper.class);
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private MdmBusinessUnitVoService mdmBusinessUnitVoService;
    private static final String CUSTOMER_CHANNEL_CODE_A1 = "A1";

    public void buildData(List<Terminal> terminals) {
        if (CollectionUtils.isEmpty(terminals)) {
            return;
        }
        HashSet customerErpCodeSet = Sets.newHashSet();
        terminals.forEach(o -> {
            String businessUnitCode = o.getBusinessUnitCode();
            if (StringUtils.hasText((String)businessUnitCode) && BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                String sellerCode = o.getSellerCode();
                String warehouseCode = o.getWarehouseCode();
                if (StringUtils.hasText((String)sellerCode)) {
                    customerErpCodeSet.add(sellerCode);
                } else if (StringUtils.hasText((String)warehouseCode)) {
                    customerErpCodeSet.add(warehouseCode);
                }
            }
        });
        if (CollectionUtils.isEmpty((Collection)customerErpCodeSet)) {
            return;
        }
        List customerVos = this.customerVoService.findByErpCodeList((List)Lists.newLinkedList((Iterable)customerErpCodeSet));
        Map<String, List<CustomerVo>> customerMap = customerVos.stream().filter(o -> StringUtils.hasText((String)o.getBusinessFormatCode()) && BusinessFormatEnum.NORMAL.getCode().equals(o.getBusinessFormatCode()) && StringUtils.hasText((String)o.getCustomerChannelCode()) && CUSTOMER_CHANNEL_CODE_A1.equals(o.getCustomerChannelCode())).collect(Collectors.groupingBy(CustomerVo::getErpCode));
        if (CollectionUtils.isEmpty(customerMap)) {
            return;
        }
        MdmBusinessUnitVo businessUnitVo = this.mdmBusinessUnitVoService.findByCode(BusinessUnitEnum.VERTICAL.getCode());
        if (CollectionUtils.isEmpty((Collection)businessUnitVo.getUnitDetailList())) {
            businessUnitVo.setUnitDetailList((List)Lists.newLinkedList());
        }
        terminals.forEach(o -> {
            String businessUnitCode = o.getBusinessUnitCode();
            if (StringUtils.hasText((String)businessUnitCode) && BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                List customerList;
                String sellerCode = o.getSellerCode();
                String warehouseCode = o.getWarehouseCode();
                if (StringUtils.hasText((String)sellerCode)) {
                    List customerList2 = (List)customerMap.get(sellerCode);
                    if (!CollectionUtils.isEmpty((Collection)customerList2)) {
                        customerList2.forEach(c -> {
                            String salesInstitutionCode = c.getSalesInstitutionCode();
                            String businessFormatCode = c.getBusinessFormatCode();
                            String customerChannelCode = c.getCustomerChannelCode();
                            businessUnitVo.getUnitDetailList().forEach(u -> {
                                if (salesInstitutionCode.equals(u.getSalesOrgCode()) && businessFormatCode.equals(u.getBusinessFormatCode()) && customerChannelCode.equals(u.getChannelCode())) {
                                    o.setSalesInstitutionCode(c.getSalesInstitutionCode());
                                    o.setSalesInstitutionName(c.getSalesInstitutionName());
                                }
                            });
                        });
                    }
                } else if (StringUtils.hasText((String)warehouseCode) && !CollectionUtils.isEmpty((Collection)(customerList = (List)customerMap.get(warehouseCode)))) {
                    customerList.forEach(c -> {
                        String salesInstitutionCode = c.getSalesInstitutionCode();
                        String businessFormatCode = c.getBusinessFormatCode();
                        String customerChannelCode = c.getCustomerChannelCode();
                        businessUnitVo.getUnitDetailList().forEach(u -> {
                            if (salesInstitutionCode.equals(u.getSalesOrgCode()) && businessFormatCode.equals(u.getBusinessFormatCode()) && customerChannelCode.equals(u.getChannelCode())) {
                                o.setSalesInstitutionCode(c.getSalesInstitutionCode());
                                o.setSalesInstitutionName(c.getSalesInstitutionName());
                            }
                        });
                    });
                }
            }
        });
    }
}

