/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalMapper;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCusSelectDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDistanceQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionRetailerCityDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionSelectDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSellingPartyDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalCusVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSellingPartyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TerminalRepository
extends ServiceImpl<TerminalMapper, Terminal> {
    private static final Integer SIZE = 1000;

    public Page<Terminal> findByConditions(Page<Terminal> page, TerminalPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((TerminalMapper)this.baseMapper).findByConditions(page, dto);
    }

    public List<Terminal> findListByConditions(TerminalPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((TerminalMapper)this.baseMapper).findListByConditions(dto);
    }

    public Terminal findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (Terminal)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidEntity::getId, (Object)id)).one());
    }

    public List<Terminal> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }

    public Terminal findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        return (Terminal)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Terminal::getTerminalCode, (Object)code)).one());
    }

    public List<Terminal> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(Terminal::getTerminalCode, codeList)).list();
    }

    public List<Terminal> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(CollectionUtils.isNotEmpty((Collection)ids), UuidEntity::getId, (Collection)ids)).or()).in(CollectionUtils.isNotEmpty((Collection)terminalCodes), Terminal::getTerminalCode, (Collection)terminalCodes);
        })).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Integer countByTerminalCode(String terminalCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Terminal::getTerminalCode, (Object)terminalCode)).count();
    }

    public List<TerminalRelaOrgVo> findTerminalRelaOrgByOrgCodes(List<String> orgCodeList) {
        return ((TerminalMapper)this.baseMapper).findTerminalRelaOrgByOrgCodes(orgCodeList, TenantUtils.getTenantCode());
    }

    public List<Terminal> findByCustomerOrgCodes(List<String> customerOrgCodes, String tenantCode, String delFlag) {
        return ((TerminalMapper)this.baseMapper).findByCustomerOrgCodes(customerOrgCodes, tenantCode, delFlag);
    }

    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        return ((TerminalMapper)this.baseMapper).findByTerminalCodeSearchDto(dto);
    }

    public List<Terminal> findByTerminalSearchDto(TerminalSearchDto dto) {
        return ((TerminalMapper)this.baseMapper).findByTerminalSearchDto(dto);
    }

    public List<Terminal> findByAmapIds(Set<String> amapIds) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Terminal::getAmapId, amapIds)).list();
    }

    public Terminal findByProcessNumber(String processNumber) {
        return (Terminal)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WorkflowFlagOpEntity::getProcessNumber, (Object)processNumber)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet())) {
            return this.findItemTerminalQueryDto(dto);
        }
        HashSet set = Sets.newHashSet();
        for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getOrgCodeSet()), (int)SIZE)) {
            dto.setOrgCodeSet((Set)Sets.newHashSet((Iterable)item));
            Set<String> cur = this.findItemTerminalQueryDto(dto);
            if (CollectionUtils.isEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    private Set<String> findItemTerminalQueryDto(TerminalQueryDto dto) {
        HashSet set = Sets.newHashSet();
        if (CollectionUtils.isEmpty((Collection)dto.getTerminalCodeSet())) {
            return ((TerminalMapper)this.baseMapper).findByTerminalQueryDto(dto, TenantUtils.getTenantCode());
        }
        for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getTerminalCodeSet()), (int)SIZE)) {
            dto.setTerminalCodeSet((Set)Sets.newHashSet((Iterable)item));
            Set<String> cur = ((TerminalMapper)this.baseMapper).findByTerminalQueryDto(dto, TenantUtils.getTenantCode());
            if (!CollectionUtils.isNotEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    public List<Terminal> findCountByCreateAccountAndFromTypeAndCreateTimeScope(String createAccount, String fromType, String startDate, String endDate) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidOpEntity::getCreateAccount, (Object)createAccount)).eq(Terminal::getFromType, (Object)fromType)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).between(UuidOpEntity::getCreateTime, (Object)startDate, (Object)endDate)).list();
    }

    public void updateByIdAndTenantCode(Terminal terminal, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{terminal.getId()});
        ((TerminalMapper)this.baseMapper).update((Object)terminal, (Wrapper)lambdaUpdateWrapper);
    }

    public List<TerminalCusVo> findTerminalBycusCodes(List<List<String>> codeList, String tenantCode) {
        return ((TerminalMapper)this.baseMapper).findTerminalBycusCodes(codeList, tenantCode);
    }

    public List<CommonSelectVo> findCusStoreFormSelectList(TerminalCusSelectDto dto) {
        return ((TerminalMapper)this.baseMapper).findCusStoreFormSelectList(dto, 50);
    }

    public List<CommonSelectVo> findStoreFormSelectList(TerminalCusSelectDto dto) {
        return ((TerminalMapper)this.baseMapper).findStoreFormSelectList(dto, 50);
    }

    public List<Terminal> findByTerminalCodeLists(List<String> terminalCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(Terminal::getTerminalCode, terminalCodeList)).list();
    }

    public List<CommonSelectVo> findRegionFormSelectList(TerminalRegionSelectDto dto) {
        return ((TerminalMapper)this.baseMapper).findRegionFormSelectList(dto, 50);
    }

    public Page<TerminalSellingPartyVo> findSellingPartyByConditions(Pageable pageable, TerminalSellingPartyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((TerminalMapper)this.baseMapper).findSellingPartyByConditions((Page<TerminalSellingPartyVo>)page, dto);
    }

    public List<CommonSelectVo> findTerminalRegion(String tenantCode) {
        return ((TerminalMapper)this.baseMapper).findTerminalRegion(tenantCode);
    }

    public List<TerminalVo> findTerminalRegionByCodes(List<List<String>> codeList, String tenantCode) {
        return ((TerminalMapper)this.baseMapper).findTerminalRegionByCodes(codeList, tenantCode);
    }

    public List<TerminalVo> findListByRegionRetailerCityCodes(TerminalRegionRetailerCityDto dto) {
        return ((TerminalMapper)this.baseMapper).findListByRegionRetailerCityCodes(dto);
    }

    public Page<TerminalVo> findBaseByDto(Page<TerminalVo> page, TerminalPaginationDto dto) {
        return ((TerminalMapper)this.baseMapper).findBaseByDto(page, dto);
    }

    public Page<Terminal> findTerminalByConditions(Page<Terminal> page, TerminalPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((TerminalMapper)this.baseMapper).findTerminalByConditions(page, dto);
    }

    public Page<TerminalVo> findTerminalDistanceByTerminalQueryDto(TerminalDistanceQueryDto dto) {
        if (ObjectUtils.isEmpty((Object)dto.getPage()) || ObjectUtils.isEmpty((Object)dto.getSize())) {
            dto.setPage(Integer.valueOf(1));
            dto.setSize(Integer.valueOf(-1));
        }
        Page page = new Page((long)dto.getPage().intValue(), (long)dto.getSize().intValue());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<TerminalVo> terminalPage = ((TerminalMapper)this.baseMapper).findTerminalDistanceByTerminalQueryDto((Page<TerminalVo>)page, dto);
        return terminalPage;
    }
}

